/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.tileentity.TileEntityAlarm;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAlarm
extends BlockContainer {
    private final boolean isLit;

    public BlockAlarm(Material material, boolean isLit) {
        super(material);
        this.isLit = isLit;
        if (this.isLit) {
            this.func_149715_a(1.0f);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return dir == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || dir == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        world.func_147464_a(x, y, z, (Block)this, 1);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int k1 = meta & 8;
        int b0 = -1;
        if (side == 0 && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            b0 = 0;
        }
        if (side == 1 && world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            b0 = 5;
        }
        if (side == 2 && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
            b0 = 4;
        }
        if (side == 3 && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
            b0 = 3;
        }
        if (side == 4 && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
            b0 = 2;
        }
        if (side == 5 && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
            b0 = 1;
        }
        return b0 + k1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        } else if (meta == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        } else if (meta == 2) {
            world.func_72921_c(x, y, z, 2, 2);
        } else if (meta == 3) {
            world.func_72921_c(x, y, z, 3, 2);
        } else if (meta == 4) {
            world.func_72921_c(x, y, z, 4, 2);
        } else if (meta == 5) {
            world.func_72921_c(x, y, z, 5, 2);
        }
    }

    public static int invertMetadata(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            this.playSoundAndUpdate(world, x, y, z);
            world.func_147464_a(x, y, z, (Block)this, 5);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            this.playSoundAndUpdate(world, x, y, z);
        }
        if (this.canPlaceAt(world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z) & 7;
            boolean notSolid = false;
            if (!world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) && meta == 0) {
                notSolid = true;
            } else if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) && meta == 1) {
                notSolid = true;
            } else if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) && meta == 2) {
                notSolid = true;
            } else if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) && meta == 3) {
                notSolid = true;
            } else if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) && meta == 4) {
                notSolid = true;
            } else if (!world.isSideSolid(x, y - 1, z, ForgeDirection.UP) && meta == 5) {
                notSolid = true;
            }
            if (notSolid) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    private boolean canPlaceAt(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z) & 7;
        float f = 0.1875f;
        float ySideMin = 0.44f - f;
        float ySideMax = 0.56f + f;
        float hSideMin = 0.44f - f;
        float hSideMax = 0.56f + f;
        float px = 0.0625f;
        switch (meta) {
            case 0: {
                this.func_149676_a(0.5f - f - px, 0.5f, 0.5f - f - px, 0.5f + f + px, 1.0f, 0.5f + f + px);
                break;
            }
            case 1: {
                this.func_149676_a(0.0f, ySideMin, hSideMin, 0.5f, ySideMax, hSideMax);
                break;
            }
            case 2: {
                this.func_149676_a(0.5f, ySideMin, hSideMin, 1.0f, ySideMax, hSideMax);
                break;
            }
            case 3: {
                this.func_149676_a(hSideMin, ySideMin, 0.0f, hSideMax, ySideMax, 0.5f);
                break;
            }
            case 4: {
                this.func_149676_a(hSideMin, ySideMin, 0.5f, hSideMax, ySideMax, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.5f - f - px, 0.0f, 0.5f - f - px, 0.5f + f + px, 0.5f, 0.5f + f + px);
            }
        }
    }

    private void playSoundAndUpdate(World world, int x, int y, int z) {
        if (!(world.func_147438_o(x, y, z) instanceof TileEntityAlarm)) {
            return;
        }
        if (world.func_72864_z(x, y, z)) {
            boolean isPowered = ((TileEntityAlarm)world.func_147438_o(x, y, z)).isPowered();
            if (!isPowered) {
                Owner owner = ((TileEntityAlarm)world.func_147438_o(x, y, z)).getOwner();
                world.func_147465_d(x, y, z, SCContent.alarmLit, world.func_72805_g(x, y, z), 3);
                ((TileEntityAlarm)world.func_147438_o(x, y, z)).getOwner().set(owner);
                ((TileEntityAlarm)world.func_147438_o(x, y, z)).setPowered(true);
            }
        } else {
            boolean isPowered = ((TileEntityAlarm)world.func_147438_o(x, y, z)).isPowered();
            if (isPowered) {
                Owner owner = ((TileEntityAlarm)world.func_147438_o(x, y, z)).getOwner();
                world.func_147465_d(x, y, z, SCContent.alarm, world.func_72805_g(x, y, z), 3);
                ((TileEntityAlarm)world.func_147438_o(x, y, z)).getOwner().set(owner);
                ((TileEntityAlarm)world.func_147438_o(x, y, z)).setPowered(false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)SCContent.alarm);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)SCContent.alarm);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAlarm();
    }
}

