/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFakeLava
extends BlockDynamicLiquid {
    private boolean[] isOptimalFlowDirection = new boolean[4];
    private int[] flowCost = new int[4];
    int numAdjacentSources;

    public BlockFakeLava(Material material) {
        super(material);
    }

    private void updateFlow(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        world.func_147465_d(x, y, z, SCContent.bogusLava, meta, 2);
    }

    public boolean func_149655_b(IBlockAccess access, int x, int y, int z) {
        return this.field_149764_J != Material.field_151587_i;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int j1;
        int flowDecay = this.func_149798_e((IBlockAccess)world, x, y, z);
        int b0 = 1;
        if (this.field_149764_J == Material.field_151587_i && !world.field_73011_w.field_76575_d) {
            b0 = 2;
        }
        boolean flag = true;
        int tickRate = this.func_149738_a(world);
        if (flowDecay > 0) {
            int b1 = -100;
            this.numAdjacentSources = 0;
            int minFlowDecay = this.getSmallestFlowDecay(world, x - 1, y, z, b1);
            minFlowDecay = this.getSmallestFlowDecay(world, x + 1, y, z, minFlowDecay);
            minFlowDecay = this.getSmallestFlowDecay(world, x, y, z - 1, minFlowDecay);
            j1 = (minFlowDecay = this.getSmallestFlowDecay(world, x, y, z + 1, minFlowDecay)) + b0;
            if (j1 >= 8 || minFlowDecay < 0) {
                j1 = -1;
            }
            if (this.func_149798_e((IBlockAccess)world, x, y + 1, z) >= 0) {
                int flowDecayAbove = this.func_149798_e((IBlockAccess)world, x, y + 1, z);
                j1 = flowDecayAbove >= 8 ? flowDecayAbove : flowDecayAbove + 8;
            }
            if (this.numAdjacentSources >= 2 && this.field_149764_J == Material.field_151586_h) {
                if (world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a()) {
                    j1 = 0;
                } else if (world.func_147439_a(x, y - 1, z).func_149688_o() == this.field_149764_J && world.func_72805_g(x, y - 1, z) == 0) {
                    j1 = 0;
                }
            }
            if (this.field_149764_J == Material.field_151587_i && flowDecay < 8 && j1 < 8 && j1 > flowDecay && random.nextInt(4) != 0) {
                tickRate *= 4;
            }
            if (j1 == flowDecay) {
                if (flag) {
                    this.updateFlow(world, x, y, z);
                }
            } else {
                flowDecay = j1;
                if (j1 < 0) {
                    world.func_147468_f(x, y, z);
                } else {
                    world.func_72921_c(x, y, z, j1, 2);
                    world.func_147464_a(x, y, z, (Block)this, tickRate);
                    world.func_147459_d(x, y, z, (Block)this);
                }
            }
        } else {
            this.updateFlow(world, x, y, z);
        }
        if (this.liquidCanDisplaceBlock(world, x, y - 1, z)) {
            if (this.field_149764_J == Material.field_151587_i && world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151586_h) {
                world.func_147449_b(x, y - 1, z, Blocks.field_150348_b);
                this.func_149799_m(world, x, y - 1, z);
                return;
            }
            if (flowDecay >= 8) {
                this.flowIntoBlock(world, x, y - 1, z, flowDecay);
            } else {
                this.flowIntoBlock(world, x, y - 1, z, flowDecay + 8);
            }
        } else if (flowDecay >= 0 && (flowDecay == 0 || this.blockedBy(world, x, y - 1, z))) {
            boolean[] directionsTemp = this.getOptimalFlowDirections(world, x, y, z);
            j1 = flowDecay + b0;
            if (flowDecay >= 8) {
                j1 = 1;
            }
            if (j1 >= 8) {
                return;
            }
            if (directionsTemp[0]) {
                this.flowIntoBlock(world, x - 1, y, z, j1);
            }
            if (directionsTemp[1]) {
                this.flowIntoBlock(world, x + 1, y, z, j1);
            }
            if (directionsTemp[2]) {
                this.flowIntoBlock(world, x, y, z - 1, j1);
            }
            if (directionsTemp[3]) {
                this.flowIntoBlock(world, x, y, z + 1, j1);
            }
        }
    }

    private void flowIntoBlock(World world, int x, int y, int z, int newFlowDecay) {
        if (this.liquidCanDisplaceBlock(world, x, y, z)) {
            Block block = world.func_147439_a(x, y, z);
            if (this.field_149764_J == Material.field_151587_i) {
                this.func_149799_m(world, x, y, z);
            } else {
                block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
            world.func_147465_d(x, y, z, (Block)this, newFlowDecay, 3);
        }
    }

    private int calculateFlowCost(World world, int x, int y, int z, int accumulatedCost, int previousDirectionOfFlow) {
        int cost = 1000;
        for (int direction = 0; direction < 4; ++direction) {
            int oppositeCost;
            if (direction == 0 && previousDirectionOfFlow == 1 || direction == 1 && previousDirectionOfFlow == 0 || direction == 2 && previousDirectionOfFlow == 3 || direction == 3 && previousDirectionOfFlow == 2) continue;
            int newX = x;
            int newZ = z;
            if (direction == 0) {
                newX = x - 1;
            }
            if (direction == 1) {
                ++newX;
            }
            if (direction == 2) {
                newZ = z - 1;
            }
            if (direction == 3) {
                ++newZ;
            }
            if (this.blockedBy(world, newX, y, newZ) || world.func_147439_a(newX, y, newZ).func_149688_o() == this.field_149764_J && world.func_72805_g(newX, y, newZ) == 0) continue;
            if (!this.blockedBy(world, newX, y - 1, newZ)) {
                return accumulatedCost;
            }
            if (accumulatedCost >= 4 || (oppositeCost = this.calculateFlowCost(world, newX, y, newZ, accumulatedCost + 1, direction)) >= cost) continue;
            cost = oppositeCost;
        }
        return cost;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_70691_i(4.0f);
            ((EntityPlayer)entity).func_70066_B();
        }
    }

    private boolean[] getOptimalFlowDirections(World world, int x, int y, int z) {
        int newX;
        int direction;
        for (direction = 0; direction < 4; ++direction) {
            this.flowCost[direction] = 1000;
            newX = x;
            int newZ = z;
            if (direction == 0) {
                newX = x - 1;
            }
            if (direction == 1) {
                ++newX;
            }
            if (direction == 2) {
                newZ = z - 1;
            }
            if (direction == 3) {
                ++newZ;
            }
            if (this.blockedBy(world, newX, y, newZ) || world.func_147439_a(newX, y, newZ).func_149688_o() == this.field_149764_J && world.func_72805_g(newX, y, newZ) == 0) continue;
            this.flowCost[direction] = this.blockedBy(world, newX, y - 1, newZ) ? this.calculateFlowCost(world, newX, y, newZ, 1, direction) : 0;
        }
        direction = this.flowCost[0];
        for (newX = 1; newX < 4; ++newX) {
            if (this.flowCost[newX] >= direction) continue;
            direction = this.flowCost[newX];
        }
        for (newX = 0; newX < 4; ++newX) {
            this.isOptimalFlowDirection[newX] = this.flowCost[newX] == direction;
        }
        return this.isOptimalFlowDirection;
    }

    private boolean blockedBy(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block != Blocks.field_150466_ao && block != Blocks.field_150454_av && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH ? (block.func_149688_o() == Material.field_151567_E ? true : block.func_149688_o().func_76230_c()) : true;
    }

    protected int getSmallestFlowDecay(World world, int x, int y, int z, int currentSmallestFlowDecay) {
        int i1 = this.func_149798_e((IBlockAccess)world, x, y, z);
        if (i1 < 0) {
            return currentSmallestFlowDecay;
        }
        if (i1 == 0) {
            ++this.numAdjacentSources;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return currentSmallestFlowDecay >= 0 && i1 >= currentSmallestFlowDecay ? currentSmallestFlowDecay : i1;
    }

    private boolean liquidCanDisplaceBlock(World world, int x, int y, int z) {
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        return material == this.field_149764_J ? false : (material == Material.field_151587_i ? false : !this.blockedBy(world, x, y, z));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.func_147439_a(x, y, z) == this) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return null;
    }
}

