/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInventoryScannerField
extends Block {
    public BlockInventoryScannerField(Material xMaterial) {
        super(xMaterial);
        this.func_149676_a(0.25f, 0.3f, 0.3f, 0.75f, 0.7f, 0.7f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        block5: {
            TileEntityInventoryScanner connectedScanner;
            block6: {
                if (world.field_72995_K) break block5;
                connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, x, y, z);
                if (connectedScanner == null) {
                    return;
                }
                if (!(e instanceof EntityPlayer)) break block6;
                if (ModuleUtils.checkForModule(connectedScanner.func_145831_w(), connectedScanner.field_145851_c, connectedScanner.field_145848_d, connectedScanner.field_145849_e, (EntityPlayer)e, EnumCustomModules.WHITELIST)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < ((EntityPlayer)e).field_71071_by.field_70462_a.length; ++j) {
                        if (connectedScanner.getStackInSlotCopy(i) == null || ((EntityPlayer)e).field_71071_by.field_70462_a[j] == null) continue;
                        this.checkInventory((EntityPlayer)e, connectedScanner, connectedScanner.getStackInSlotCopy(i));
                    }
                }
                break block5;
            }
            if (!(e instanceof EntityItem)) break block5;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i) == null || ((EntityItem)e).func_92059_d() == null) continue;
                this.checkEntityItem((EntityItem)e, connectedScanner, connectedScanner.getStackInSlotCopy(i));
            }
        }
    }

    public void checkInventory(EntityPlayer entity, TileEntityInventoryScanner te, ItemStack stack) {
        block4: {
            block3: {
                if (!te.getType().equals("redstone")) break block3;
                for (int i = 1; i <= entity.field_71071_by.field_70462_a.length; ++i) {
                    if (entity.field_71071_by.field_70462_a[i - 1] == null || (!te.hasModule(EnumCustomModules.SMART) || !BlockInventoryScannerField.areItemStacksEqual(entity.field_71071_by.field_70462_a[i - 1], stack) || !ItemStack.func_77970_a((ItemStack)entity.field_71071_by.field_70462_a[i - 1], (ItemStack)stack)) && (te.hasModule(EnumCustomModules.SMART) || entity.field_71071_by.field_70462_a[i - 1].func_77973_b() != stack.func_77973_b())) continue;
                    this.updateInventoryScannerPower(te);
                }
                break block4;
            }
            if (!te.getType().equals("check")) break block4;
            for (int i = 1; i <= entity.field_71071_by.field_70462_a.length; ++i) {
                if (entity.field_71071_by.field_70462_a[i - 1] == null || (!te.hasModule(EnumCustomModules.SMART) || !BlockInventoryScannerField.areItemStacksEqual(entity.field_71071_by.field_70462_a[i - 1], stack) || !ItemStack.func_77970_a((ItemStack)entity.field_71071_by.field_70462_a[i - 1], (ItemStack)stack)) && (te.hasModule(EnumCustomModules.SMART) || entity.field_71071_by.field_70462_a[i - 1].func_77973_b() != stack.func_77973_b())) continue;
                if (te.hasModule(EnumCustomModules.STORAGE)) {
                    te.addItemToStorage(entity.field_71071_by.field_70462_a[i - 1]);
                }
                entity.field_71071_by.field_70462_a[i - 1] = null;
            }
        }
    }

    public void checkEntityItem(EntityItem entity, TileEntityInventoryScanner te, ItemStack stack) {
        if (te.getType().equals("redstone")) {
            if (te.hasModule(EnumCustomModules.SMART) && BlockInventoryScannerField.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !te.hasModule(EnumCustomModules.SMART) && entity.func_92059_d().func_77973_b() == stack.func_77973_b()) {
                this.updateInventoryScannerPower(te);
            }
        } else if (te.getType().equals("check") && (te.hasModule(EnumCustomModules.SMART) && BlockInventoryScannerField.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !te.hasModule(EnumCustomModules.SMART) && entity.func_92059_d().func_77973_b() == stack.func_77973_b())) {
            if (te.hasModule(EnumCustomModules.STORAGE)) {
                te.addItemToStorage(entity.func_92059_d());
            }
            entity.func_70106_y();
        }
    }

    public void updateInventoryScannerPower(TileEntityInventoryScanner te) {
        if (!te.shouldProvidePower()) {
            te.setShouldProvidePower(true);
        }
        te.setCooldown(60);
        this.checkAndUpdateTEAppropriately(te);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e), 1, true);
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.func_77946_l();
        ItemStack s2 = stack2.func_77946_l();
        s1.field_77994_a = 1;
        s2.field_77994_a = 1;
        return ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
    }

    private void checkAndUpdateTEAppropriately(TileEntityInventoryScanner te) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        if (connectedScanner == null) {
            return;
        }
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e), 1, true);
        connectedScanner.setShouldProvidePower(true);
        connectedScanner.setCooldown(60);
        BlockUtils.updateAndNotify(connectedScanner.func_145831_w(), connectedScanner.field_145851_c, connectedScanner.field_145848_d, connectedScanner.field_145849_e, connectedScanner.func_145831_w().func_147439_a(connectedScanner.field_145851_c, connectedScanner.field_145848_d, connectedScanner.field_145849_e), 1, true);
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            int j;
            int i;
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_147480_a(x - j, y, z, false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (world.func_147439_a(x + i, y, z) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_147480_a(x + j, y, z, false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_147480_a(x, y, z - j, false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (world.func_147439_a(x, y, z + i) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_147480_a(x, y, z + j, false);
                }
                break;
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int entityRotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (entityRotation == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (entityRotation == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (entityRotation == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (entityRotation == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        if (access.func_72805_g(x, y, z) == 1) {
            this.func_149676_a(0.0f, 0.0f, 0.4f, 1.0f, 1.0f, 0.6f);
        } else if (access.func_72805_g(x, y, z) == 2) {
            this.func_149676_a(0.4f, 0.0f, 0.0f, 0.6f, 1.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("securitycraft:aniLaser");
    }
}

