/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.compat.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockKeypad
extends BlockContainer
implements ICustomWailaDisplay,
IPasswordConvertible {
    @SideOnly(value=Side.CLIENT)
    private IIcon keypadIconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon keypadIconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon keypadIconFrontActive;
    @SideOnly(value=Side.CLIENT)
    private IIcon keypadIconDisguised;

    public BlockKeypad(Material material) {
        super(material);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityKeypad && ((TileEntityKeypad)te).hasModule(EnumCustomModules.DISGUISE)) {
            ItemStack module = ((TileEntityKeypad)te).getModule(EnumCustomModules.DISGUISE);
            return ((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).get(0).isSideSolid(world, x, y, z, side);
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int entityRotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (entityRotation == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (entityRotation == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (entityRotation == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (entityRotation != 3) {
            return;
        }
        world.func_72921_c(x, y, z, 4, 2);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (BlockUtils.isMetadataBetween((IBlockAccess)world, x, y, z, 7, 10)) {
            return false;
        }
        if (ModuleUtils.checkForModule(world, x, y, z, player, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(world, x, y, z, player, EnumCustomModules.BLACKLIST)) {
            return true;
        }
        if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker)) {
            ((IPasswordProtected)world.func_147438_o(x, y, z)).openPasswordGUI(player);
        }
        return true;
    }

    public static void activate(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) + 5, 3);
        world.func_147459_d(x, y, z, SCContent.keypad);
        world.func_147464_a(x, y, z, SCContent.keypad, 60);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) > 6 && world.func_72805_g(x, y, z) < 11) {
            world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) - 5, 3);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess access, int x, int y, int z, int side) {
        if (access.func_72805_g(x, y, z) == 7 || access.func_72805_g(x, y, z) == 8 || access.func_72805_g(x, y, z) == 9 || access.func_72805_g(x, y, z) == 10) {
            return 15;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess access, int x, int y, int z, int side) {
        if (access.func_72805_g(x, y, z) == 7 || access.func_72805_g(x, y, z) == 8 || access.func_72805_g(x, y, z) == 9 || access.func_72805_g(x, y, z) == 10) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 3 && meta == 0) {
            return this.keypadIconFront;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        ArrayList<ItemStack> stacks;
        int meta = access.func_72805_g(x, y, z);
        TileEntityKeypad tileEntity = (TileEntityKeypad)access.func_147438_o(x, y, z);
        boolean isDisguised = tileEntity.hasModule(EnumCustomModules.DISGUISE);
        if (isDisguised && !tileEntity.getAddonsFromModule(EnumCustomModules.DISGUISE).isEmpty() && (stacks = tileEntity.getAddonsFromModule(EnumCustomModules.DISGUISE)).size() != 0) {
            ItemStack stack = (ItemStack)stacks.get(0);
            Block disguisedAs = Block.func_149634_a((Item)stack.func_77973_b());
            return stack.func_77981_g() ? disguisedAs.func_149691_a(side, stack.func_77960_j()) : disguisedAs.func_149691_a(side, meta);
        }
        if (meta > 6 && meta < 11) {
            return side == 1 ? this.keypadIconTop : (side == 0 ? this.keypadIconTop : (side != meta - 5 ? this.field_149761_L : this.keypadIconFrontActive));
        }
        return side == 1 ? this.keypadIconTop : (side == 0 ? this.keypadIconTop : (side != meta ? this.field_149761_L : this.keypadIconFront));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("securitycraft:iron_block");
        this.keypadIconFront = register.func_94245_a("securitycraft:keypadUnactive");
        this.keypadIconTop = register.func_94245_a("securitycraft:iron_block");
        this.keypadIconFrontActive = register.func_94245_a("securitycraft:keypadActive");
        this.keypadIconDisguised = register.func_94245_a("bookshelf");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeypad();
    }

    @Override
    public ItemStack getDisplayStack(World world, int x, int y, int z) {
        TileEntityKeypad tileEntity = (TileEntityKeypad)world.func_147438_o(x, y, z);
        if (tileEntity.hasModule(EnumCustomModules.DISGUISE) && !tileEntity.getAddonsFromModule(EnumCustomModules.DISGUISE).isEmpty()) {
            return tileEntity.getAddonsFromModule(EnumCustomModules.DISGUISE).get(0);
        }
        return null;
    }

    @Override
    public boolean shouldShowSCInfo(World world, int x, int y, int z) {
        TileEntityKeypad tileEntity = (TileEntityKeypad)world.func_147438_o(x, y, z);
        return !tileEntity.hasModule(EnumCustomModules.DISGUISE);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack stack = this.getDisplayStack(world, x, y, z);
        return stack == null ? new ItemStack((Block)this) : stack;
    }

    @Override
    public Block getOriginalBlock() {
        return SCContent.frame;
    }

    @Override
    public boolean convert(EntityPlayer player, World world, int x, int y, int z) {
        Owner owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
        world.func_147465_d(x, y, z, SCContent.keypad, world.func_72805_g(x, y, z), 3);
        ((IOwnable)world.func_147438_o(x, y, z)).getOwner().set(owner);
        return true;
    }
}

