/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.tileentity.TileEntityClaymore;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockClaymore
extends BlockContainer
implements IExplosive {
    private final boolean isActive;

    public BlockClaymore(Material material, boolean isActive) {
        super(material);
        this.isActive = isActive;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149742_c(World worldIn, int x, int y, int z) {
        return worldIn.func_147439_a(x, y - 1, z).isSideSolid((IBlockAccess)worldIn, x, y - 1, z, ForgeDirection.UP);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == SCContent.wireCutters) {
                world.func_147465_d(x, y, z, SCContent.claymoreDefused, world.func_72805_g(x, y, z), 3);
                return true;
            }
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151033_d) {
                world.func_147465_d(x, y, z, SCContent.claymoreActive, world.func_72805_g(x, y, z), 3);
                return true;
            }
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int entityRotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (entityRotation == 0) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (entityRotation == 1) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (entityRotation == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (entityRotation != 3) {
            return;
        }
        world.func_72921_c(x, y, z, 2, 2);
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        if (meta == 3) {
            this.func_149676_a(0.225f, 0.0f, 0.175f, 0.775f, 0.325f, 0.45f);
        } else if (meta == 1) {
            this.func_149676_a(0.225f, 0.0f, 0.55f, 0.775f, 0.325f, 0.825f);
        } else if (meta == 2) {
            this.func_149676_a(0.55f, 0.0f, 0.225f, 0.825f, 0.335f, 0.775f);
        } else {
            this.func_149676_a(0.175f, 0.0f, 0.225f, 0.45f, 0.335f, 0.775f);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!world.field_72995_K && world.func_147439_a(x, y, z) != SCContent.claymoreDefused) {
            BlockUtils.destroyBlock(world, x, y, z, false);
            world.func_72876_a((Entity)null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.5f, true);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149723_a(World worldIn, int x, int y, int z, Explosion explosion) {
        if (!worldIn.field_72995_K && worldIn.func_147439_a(x, y, z) instanceof IExplosive && worldIn.func_147439_a(x, y, z) == SCContent.claymoreActive) {
            if ((double)x == explosion.field_77284_b && (double)y == explosion.field_77285_c && (double)z == explosion.field_77282_d) {
                return;
            }
            BlockUtils.destroyBlock(worldIn, x, y, z, false);
            worldIn.func_72876_a((Entity)null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.5f, true);
        }
    }

    @Override
    public void activateMine(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Owner owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
            world.func_147449_b(x, y, z, SCContent.claymoreActive);
            ((IOwnable)world.func_147438_o(x, y, z)).setOwner(owner.getUUID(), owner.getName());
        }
    }

    @Override
    public void defuseMine(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Owner owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
            world.func_147449_b(x, y, z, SCContent.claymoreDefused);
            ((IOwnable)world.func_147438_o(x, y, z)).setOwner(owner.getUUID(), owner.getName());
        }
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            BlockUtils.destroyBlock(world, x, y, z, false);
            world.func_72876_a((Entity)null, (double)x, (double)y, (double)z, 3.5f, true);
        }
    }

    @Override
    public boolean isActive(World world, int x, int y, int z) {
        return this.isActive;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)SCContent.claymoreActive);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityClaymore();
    }
}

