/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockMine
extends BlockExplosive {
    public boolean cut;

    public BlockMine(Material material, boolean cut) {
        super(material);
        float f = 0.2f;
        float g = 0.1f;
        this.cut = cut;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, g * 2.0f / 2.0f + 0.1f, 0.5f + f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151579_a) {
            return;
        }
        this.explode(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151592_s && world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151570_A && world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151579_a && world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151568_F && world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151585_k;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!world.field_72995_K) {
            if (player != null && player.field_71075_bZ.field_75098_d && !SecurityCraft.config.mineExplodesWhenInCreative) {
                return super.removedByPlayer(world, player, x, y, z, willHarvest);
            }
            this.explode(world, x, y, z);
            return super.removedByPlayer(world, player, x, y, z, willHarvest);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof EntityCreeper || entity instanceof EntityOcelot || entity instanceof EntityEnderman || entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, x, y, z);
        }
    }

    public Explosion newExplosion(Entity entity, double size, double x, double y, float z, boolean smoke, World world) {
        Explosion explosion = new Explosion(world, entity, size, x, y, z);
        explosion.field_77286_a = SecurityCraft.config.shouldSpawnFire;
        explosion.field_82755_b = smoke;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)SCContent.mine);
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)SCContent.mine);
    }

    @Override
    public void activateMine(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Owner owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
            world.func_147449_b(x, y, z, (Block)SCContent.mine);
            ((IOwnable)world.func_147438_o(x, y, z)).setOwner(owner.getUUID(), owner.getName());
        }
    }

    @Override
    public void defuseMine(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Owner owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
            world.func_147449_b(x, y, z, (Block)SCContent.mineCut);
            ((IOwnable)world.func_147438_o(x, y, z)).setOwner(owner.getUUID(), owner.getName());
        }
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (!this.cut) {
            world.func_147480_a(x, y, z, false);
            if (SecurityCraft.config.smallerMineExplosion) {
                this.newExplosion(null, x, y, z, 1.0f, true, world);
            } else {
                this.newExplosion(null, x, y, z, 3.0f, true, world);
            }
        }
    }

    @Override
    public boolean isActive(World world, int x, int y, int z) {
        return !this.cut;
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = this.cut ? register.func_94245_a("securitycraft:mineCut") : register.func_94245_a("securitycraft:mine");
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable();
    }
}

