/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReinforcedDoor
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] upperIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] lowerIcons;

    public BlockReinforcedDoor(Material material) {
        super(material);
        this.field_149758_A = true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 7;
    }

    public boolean func_149655_b(IBlockAccess access, int x, int y, int z) {
        int l = this.getDoorMeta(access, x, y, z);
        return (l & 4) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        this.setBoundsBasedOnMeta(this.getDoorMeta(access, x, y, z));
    }

    private void setBoundsBasedOnMeta(int meta) {
        boolean isRightDoor;
        float f = 0.1875f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        int facing = meta & 3;
        boolean isOpen = (meta & 4) != 0;
        boolean bl = isRightDoor = (meta & 0x10) != 0;
        if (facing == 0) {
            if (isOpen) {
                if (!isRightDoor) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
            }
        } else if (facing == 1) {
            if (isOpen) {
                if (!isRightDoor) {
                    this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
            }
        } else if (facing == 2) {
            if (isOpen) {
                if (!isRightDoor) {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                }
            } else {
                this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (facing == 3) {
            if (isOpen) {
                if (!isRightDoor) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void changeDoorState(World world, int x, int y, int z, boolean open) {
        boolean isOpen;
        int meta = this.getDoorMeta((IBlockAccess)world, x, y, z);
        boolean bl = isOpen = (meta & 4) != 0;
        if (isOpen != open) {
            int newMeta = meta & 7;
            newMeta ^= 4;
            if ((meta & 8) == 0) {
                world.func_72921_c(x, y, z, newMeta, 2);
                world.func_147458_c(x, y, z, x, y, z);
                switch (meta) {
                    case 0: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 16) break;
                        world.func_72921_c(x, y, z + 1, open ? 20 : 0, 2);
                        world.func_147458_c(x, y, z + 1, x, y, z);
                        break;
                    }
                    case 16: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 0) break;
                        world.func_72921_c(x, y, z - 1, open ? 4 : 16, 2);
                        world.func_147458_c(x, y, z - 1, x, y, z);
                        break;
                    }
                    case 1: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 17) break;
                        world.func_72921_c(x - 1, y, z, open ? 21 : 1, 2);
                        world.func_147458_c(x - 1, y, z, x, y, z);
                        break;
                    }
                    case 17: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 1) break;
                        world.func_72921_c(x + 1, y, z, open ? 5 : 17, 2);
                        world.func_147458_c(x + 1, y, z, x, y, z);
                        break;
                    }
                    case 2: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 18) break;
                        world.func_72921_c(x, y, z - 1, open ? 22 : 2, 2);
                        world.func_147458_c(x, y, z - 1, x, y, z);
                        break;
                    }
                    case 18: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 2) break;
                        world.func_72921_c(x, y, z + 1, open ? 6 : 18, 2);
                        world.func_147458_c(x, y, z + 1, x, y, z);
                        break;
                    }
                    case 3: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 19) break;
                        world.func_72921_c(x + 1, y, z, open ? 23 : 3, 2);
                        world.func_147458_c(x + 1, y, z, x, y, z);
                        break;
                    }
                    case 19: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 3) break;
                        world.func_72921_c(x - 1, y, z, open ? 7 : 19, 2);
                        world.func_147458_c(x - 1, y, z, x, y, z);
                    }
                }
            } else {
                world.func_72921_c(x, y - 1, z, newMeta, 2);
                world.func_147458_c(x, y - 1, z, x, y, z);
                switch (meta) {
                    case 24: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 8) break;
                        world.func_72921_c(x, y, z + 1, open ? 12 : 24, 2);
                        world.func_147458_c(x, y, z + 1, x, y, z);
                        break;
                    }
                    case 8: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 24) break;
                        world.func_72921_c(x, y, z - 1, open ? 28 : 8, 2);
                        world.func_147458_c(x, y, z - 1, x, y, z);
                        break;
                    }
                    case 25: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 9) break;
                        world.func_72921_c(x - 1, y, z, open ? 13 : 25, 2);
                        world.func_147458_c(x - 1, y, z, x, y, z);
                        break;
                    }
                    case 9: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 25) break;
                        world.func_72921_c(x + 1, y, z, open ? 29 : 9, 2);
                        world.func_147458_c(x + 1, y, z, x, y, z);
                        break;
                    }
                    case 26: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 10) break;
                        world.func_72921_c(x, y, z - 1, open ? 14 : 26, 2);
                        world.func_147458_c(x, y, z - 1, x, y, z);
                        break;
                    }
                    case 10: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 26) break;
                        world.func_72921_c(x, y, z + 1, open ? 30 : 10, 2);
                        world.func_147458_c(x, y, z + 1, x, y, z);
                        break;
                    }
                    case 27: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 11) break;
                        world.func_72921_c(x + 1, y, z, open ? 15 : 27, 2);
                        world.func_147458_c(x + 1, y, z, x, y, z);
                        break;
                    }
                    case 11: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 27) break;
                        world.func_72921_c(x - 1, y, z, open ? 31 : 11, 2);
                        world.func_147458_c(x - 1, y, z, x, y, z);
                    }
                }
            }
            world.func_72889_a((EntityPlayer)null, 1003, x, y, z, 0);
        }
        if (!open) {
            if ((meta & 8) == 0) {
                switch (meta) {
                    case 4: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 20) break;
                        this.changeDoorState(world, x, y, z + 1, false);
                        break;
                    }
                    case 20: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 4) break;
                        this.changeDoorState(world, x, y, z - 1, false);
                        break;
                    }
                    case 5: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 21) break;
                        this.changeDoorState(world, x - 1, y, z, false);
                        break;
                    }
                    case 21: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 5) break;
                        this.changeDoorState(world, x + 1, y, z, false);
                        break;
                    }
                    case 6: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 22) break;
                        this.changeDoorState(world, x, y, z - 1, false);
                        break;
                    }
                    case 22: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 6) break;
                        this.changeDoorState(world, x, y, z + 1, false);
                        break;
                    }
                    case 7: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 23) break;
                        this.changeDoorState(world, x + 1, y, z, false);
                        break;
                    }
                    case 23: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 7) break;
                        this.changeDoorState(world, x - 1, y, z, false);
                    }
                }
            } else {
                switch (meta) {
                    case 28: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 12) break;
                        this.changeDoorState(world, x, y, z + 1, false);
                        break;
                    }
                    case 12: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 28) break;
                        this.changeDoorState(world, x, y, z - 1, false);
                        break;
                    }
                    case 29: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 13) break;
                        this.changeDoorState(world, x - 1, y, z, false);
                        break;
                    }
                    case 13: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 29) break;
                        this.changeDoorState(world, x + 1, y, z, false);
                        break;
                    }
                    case 30: {
                        if (world.func_147439_a(x, y, z - 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z - 1) != 14) break;
                        this.changeDoorState(world, x, y, z - 1, false);
                        break;
                    }
                    case 14: {
                        if (world.func_147439_a(x, y, z + 1) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x, y, z + 1) != 30) break;
                        this.changeDoorState(world, x, y, z + 1, false);
                        break;
                    }
                    case 31: {
                        if (world.func_147439_a(x + 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x + 1, y, z) != 15) break;
                        this.changeDoorState(world, x + 1, y, z, false);
                        break;
                    }
                    case 15: {
                        if (world.func_147439_a(x - 1, y, z) != SCContent.reinforcedDoor || this.getDoorMeta((IBlockAccess)world, x - 1, y, z) != 31) break;
                        this.changeDoorState(world, x - 1, y, z, false);
                    }
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            boolean flag = false;
            if (world.func_147439_a(x, y + 1, z) != this) {
                world.func_147468_f(x, y, z);
                flag = true;
            }
            if (flag) {
                if (!world.field_72995_K) {
                    this.func_149697_b(world, x, y, z, meta, 0);
                }
            } else if (block.func_149744_f() && block != this) {
                if (BlockUtils.hasActiveSCBlockNextTo(world, x, y, z) || BlockUtils.hasActiveSCBlockNextTo(world, x, y + 1, z)) {
                    this.changeDoorState(world, x, y, z, true);
                } else {
                    this.changeDoorState(world, x, y, z, false);
                }
            }
        } else {
            if (world.func_147439_a(x, y - 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
            if (block != this) {
                this.func_149695_a(world, x, y - 1, z, block);
            }
        }
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return (meta & 8) != 0 ? null : SCContent.reinforcedDoorItem;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, start, end);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return y >= 255 ? false : World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && super.func_149742_c(world, x, y, z) && super.func_149742_c(world, x, y + 1, z);
    }

    public int func_149656_h() {
        return 1;
    }

    public int getDoorMeta(IBlockAccess access, int x, int y, int z) {
        int j1;
        int i1;
        boolean isOpen;
        int meta = access.func_72805_g(x, y, z);
        boolean bl = isOpen = (meta & 8) != 0;
        if (isOpen) {
            i1 = access.func_72805_g(x, y - 1, z);
            j1 = meta;
        } else {
            i1 = meta;
            j1 = access.func_72805_g(x, y + 1, z);
        }
        boolean isRightDoor = (j1 & 1) != 0;
        return i1 & 7 | (isOpen ? 8 : 0) | (isRightDoor ? 16 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return SCContent.reinforcedDoorItem;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && (meta & 8) != 0 && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147468_f(x, y - 1, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.lowerIcons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        if (side != 1 && side != 0) {
            boolean flag2;
            int meta = this.getDoorMeta(access, x, y, z);
            int facing = meta & 3;
            boolean flag = (meta & 4) != 0;
            boolean flag1 = false;
            boolean bl = flag2 = (meta & 8) != 0;
            if (flag) {
                if (facing == 0 && side == 2) {
                    flag1 = !flag1;
                } else if (facing == 1 && side == 5) {
                    flag1 = !flag1;
                } else if (facing == 2 && side == 3) {
                    flag1 = !flag1;
                } else if (facing == 3 && side == 4) {
                    flag1 = !flag1;
                }
            } else {
                if (facing == 0 && side == 5) {
                    flag1 = !flag1;
                } else if (facing == 1 && side == 3) {
                    flag1 = !flag1;
                } else if (facing == 2 && side == 4) {
                    flag1 = !flag1;
                } else if (facing == 3 && side == 2) {
                    boolean bl2 = flag1 = !flag1;
                }
                if ((meta & 0x10) != 0) {
                    boolean bl3 = flag1 = !flag1;
                }
            }
            return flag2 ? this.upperIcons[flag1 ? 1 : 0] : this.lowerIcons[flag1 ? 1 : 0];
        }
        return this.lowerIcons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.upperIcons = new IIcon[2];
        this.lowerIcons = new IIcon[2];
        this.upperIcons[0] = register.func_94245_a("securitycraft:reinforcedDoorUpper");
        this.lowerIcons[0] = register.func_94245_a("securitycraft:reinforcedDoorLower");
        this.upperIcons[1] = new IconFlipped(this.upperIcons[0], true, false);
        this.lowerIcons[1] = new IconFlipped(this.lowerIcons[0], true, false);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable();
    }
}

