/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReinforcedSlabs
extends BlockSlab
implements ITileEntityProvider {
    public static final String[] variants = new String[]{"stone", "cobble", "sand", "dirt", "stonebrick", "brick", "netherbrick", "quartz"};
    private final Material slabMaterial;

    public BlockReinforcedSlabs(boolean isDouble, Material material) {
        super(isDouble, material);
        this.slabMaterial = material;
        this.field_149783_u = true;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityWither);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5Block, int par6) {
        super.func_149749_a(world, x, y, z, par5Block, par6);
        world.func_147475_p(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        if (this.slabMaterial != Material.field_151578_c) {
            for (int i = 0; i < variants.length; ++i) {
                if (i == 3) continue;
                list.add(new ItemStack(item, 1, i));
            }
        } else {
            list.add(new ItemStack(item, 1, 3));
        }
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return this.slabMaterial == Material.field_151578_c ? Item.func_150898_a((Block)SCContent.reinforcedDirtSlab) : Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.slabMaterial == Material.field_151578_c ? Item.func_150898_a((Block)SCContent.reinforcedDirtSlab) : Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs), 2, meta & 7);
    }

    public String func_150002_b(int meta) {
        if (meta < 0 || meta >= variants.length) {
            meta = 0;
        }
        return super.func_149739_a() + "." + variants[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int block = this.getSlabBlock(meta);
        return Block.func_149729_e((int)this.getSlabBlock(meta)).func_149691_a(side, block == 24 && (meta != 2 || meta != 10) ? 0 : meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        int block = this.getSlabBlock(meta);
        return Block.func_149729_e((int)block).func_149691_a(side, block == 24 && (meta != 2 || meta != 10) ? 0 : meta);
    }

    private int getSlabBlock(int meta) {
        switch (meta) {
            case 0: 
            case 8: {
                return 44;
            }
            case 1: 
            case 9: {
                return 4;
            }
            case 2: 
            case 10: {
                return 24;
            }
            case 3: 
            case 11: {
                return 3;
            }
            case 4: 
            case 12: {
                return 98;
            }
            case 5: 
            case 13: {
                return 45;
            }
            case 6: 
            case 14: {
                return 112;
            }
            case 7: 
            case 15: {
                return 155;
            }
        }
        return 0;
    }

    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return 0x999999;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return 0x999999;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0x999999;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable();
    }
}

