/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.itemblocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedSlabs;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedWoodSlabs;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBlockReinforcedSlabs
extends ItemBlock {
    private final boolean isNotSlab;
    private final BlockSlab singleSlab;
    private final ReinforcedSlabType slabType;

    public ItemBlockReinforcedSlabs(Block blockType, BlockReinforcedWoodSlabs slabBlock, Boolean notSlab, ReinforcedSlabType slabType) {
        super(blockType);
        this.singleSlab = slabBlock;
        this.isNotSlab = notSlab;
        this.slabType = slabType;
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public ItemBlockReinforcedSlabs(Block blockType, BlockReinforcedSlabs slabBlock, Boolean notSlab, ReinforcedSlabType slabType) {
        super(blockType);
        this.singleSlab = slabBlock;
        this.isNotSlab = notSlab;
        this.slabType = slabType;
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (this.slabType == ReinforcedSlabType.OTHER) {
            return SCContent.reinforcedStoneSlabs.func_149691_a(2, meta);
        }
        return SCContent.reinforcedWoodSlabs.func_149691_a(2, meta);
    }

    public String func_77667_c(ItemStack stack) {
        if (this.slabType == ReinforcedSlabType.WOOD) {
            if (stack.func_77960_j() == 0) {
                return this.func_77658_a() + "_oak";
            }
            if (stack.func_77960_j() == 1) {
                return this.func_77658_a() + "_spruce";
            }
            if (stack.func_77960_j() == 2) {
                return this.func_77658_a() + "_birch";
            }
            if (stack.func_77960_j() == 3) {
                return this.func_77658_a() + "_jungle";
            }
            if (stack.func_77960_j() == 4) {
                return this.func_77658_a() + "_acacia";
            }
            if (stack.func_77960_j() == 5) {
                return this.func_77658_a() + "_darkoak";
            }
            return this.func_77658_a();
        }
        if (stack.func_77960_j() == 0) {
            return this.func_77658_a() + "_stone";
        }
        if (stack.func_77960_j() == 1) {
            return this.func_77658_a() + "_cobble";
        }
        if (stack.func_77960_j() == 2) {
            return this.func_77658_a() + "_sandstone";
        }
        if (stack.func_77960_j() == 4) {
            return this.func_77658_a() + "_stonebrick";
        }
        if (stack.func_77960_j() == 5) {
            return this.func_77658_a() + "_brick";
        }
        if (stack.func_77960_j() == 6) {
            return this.func_77658_a() + "_netherbrick";
        }
        if (stack.func_77960_j() == 7) {
            return this.func_77658_a() + "_quartz";
        }
        return this.func_77658_a();
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.isNotSlab) {
            return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        int blockType = meta & 7;
        boolean flag = (meta & 8) != 0;
        Owner owner = null;
        if (world.func_147438_o(x, y, z) instanceof IOwnable) {
            owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
            if (!((IOwnable)world.func_147438_o(x, y, z)).getOwner().isOwner(player)) {
                if (!world.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(player, StatCollector.func_74838_a((String)"messages.securitycraft:reinforcedSlab"), StatCollector.func_74838_a((String)"messages.securitycraft:reinforcedSlab.cannotDoubleSlab"), EnumChatFormatting.RED);
                }
                return false;
            }
        }
        if ((side == 1 && !flag || side == 0 && flag) && this.isBlock(block) && blockType == stack.func_77960_j()) {
            if (world.func_72855_b(this.getBlockVariant(meta).func_149668_a(world, x, y, z)) && world.func_147465_d(x, y, z, this.getBlockVariant(block, meta), block == SCContent.reinforcedStoneSlabs && meta == 2 ? 2 : blockType, 3)) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.getBlockVariant((Block)block, (int)meta).field_149762_H.func_150496_b(), (this.getBlockVariant((Block)block, (int)meta).field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.getBlockVariant((Block)block, (int)meta).field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
                if (owner != null) {
                    ((IOwnable)world.func_147438_o(x, y, z)).getOwner().set(owner);
                }
            }
            return true;
        }
        return this.tryPlace(stack, player, world, x, y, z, side) ? true : super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack stack) {
        boolean flag;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        int blockType = meta & 7;
        boolean bl = flag = (meta & 8) != 0;
        if ((side == 1 && !flag || side == 0 && flag) && block == this.singleSlab && blockType == stack.func_77960_j()) {
            return true;
        }
        if (side == 0) {
            --y;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        Block block1 = world.func_147439_a(x, y, z);
        int block1Meta = world.func_72805_g(x, y, z);
        blockType = block1Meta & 7;
        return block1 == this.singleSlab && blockType == stack.func_77960_j() ? true : super.func_150936_a(world, x, y, z, side, player, stack);
    }

    private boolean tryPlace(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int meta) {
        if (meta == 0) {
            --y;
        }
        if (meta == 1) {
            ++y;
        }
        if (meta == 2) {
            --z;
        }
        if (meta == 3) {
            ++z;
        }
        if (meta == 4) {
            --x;
        }
        if (meta == 5) {
            ++x;
        }
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        int blockType = blockMeta & 7;
        Owner owner = null;
        if (world.func_147438_o(x, y, z) instanceof IOwnable) {
            owner = ((IOwnable)world.func_147438_o(x, y, z)).getOwner();
        }
        if (block == this.singleSlab && blockType == stack.func_77960_j()) {
            if (world.func_72855_b(this.getBlockVariant(blockMeta).func_149668_a(world, x, y, z)) && world.func_147465_d(x, y, z, this.getBlockVariant(blockMeta), blockType, 3)) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.getBlockVariant((int)blockMeta).field_149762_H.func_150496_b(), (this.getBlockVariant((int)blockMeta).field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.getBlockVariant((int)blockMeta).field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
                if (owner != null) {
                    ((IOwnable)world.func_147438_o(x, y, z)).getOwner().set(owner.getUUID(), owner.getName());
                }
            }
            return true;
        }
        return false;
    }

    public Block getBlockVariant(Block slab, int meta) {
        if (slab == SCContent.reinforcedWoodSlabs) {
            return SCContent.reinforcedDoubleWoodSlabs;
        }
        if (slab == SCContent.reinforcedStoneSlabs) {
            return SCContent.reinforcedDoubleStoneSlabs;
        }
        if (slab == SCContent.reinforcedDirtSlab) {
            return SCContent.reinforcedDoubleDirtSlab;
        }
        return slab;
    }

    public Block getBlockVariant(int meta) {
        if (this.slabType == ReinforcedSlabType.OTHER) {
            return Block.func_149634_a((Item)new ItemStack(SCContent.reinforcedStoneSlabs, 1, meta).func_77973_b());
        }
        return Block.func_149634_a((Item)new ItemStack(SCContent.reinforcedWoodSlabs, 1, meta).func_77973_b());
    }

    public boolean isBlock(Block block) {
        if (this.slabType == ReinforcedSlabType.OTHER) {
            return block == SCContent.reinforcedStoneSlabs || block == SCContent.reinforcedDirtSlab;
        }
        return block == SCContent.reinforcedWoodSlabs;
    }

    public static enum ReinforcedSlabType {
        WOOD,
        OTHER;

    }
}

