/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityKeypadChestRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation christmasDouble = new ResourceLocation("securitycraft:textures/entity/chest/christmas_double.png");
    private static final ResourceLocation normalDoubleUnactive = new ResourceLocation("securitycraft:textures/entity/chest/doubleChestUnactive.png");
    private static final ResourceLocation normalDoubleActive = new ResourceLocation("securitycraft:textures/entity/chest/doubleChestActive.png");
    private static final ResourceLocation christmasNormal = new ResourceLocation("securitycraft:textures/entity/chest/christmas.png");
    private static final ResourceLocation normalSingleUnactive = new ResourceLocation("securitycraft:textures/entity/chest/chestUnactive.png");
    private static final ResourceLocation normalSingleActive = new ResourceLocation("securitycraft:textures/entity/chest/chestActive.png");
    private static final ModelChest smallModel = new ModelChest();
    private static final ModelChest largeModel = new ModelLargeChest();
    private boolean isChristmas;

    public TileEntityKeypadChestRenderer() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void renderTileEntityAt(TileEntityChest te, double x, double y, double z, float partialTicks) {
        int meta;
        if (!te.func_145830_o()) {
            meta = 0;
        } else {
            Block block = te.func_145838_q();
            meta = te.func_145832_p();
            if (block instanceof BlockChest && meta == 0) {
                try {
                    ((BlockChest)block).func_149954_e(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
                }
                catch (ClassCastException e) {
                    FMLLog.severe((String)"Attempted to render a chest at %d,  %d, %d that was not a chest", (Object[])new Object[]{te.field_145851_c, te.field_145848_d, te.field_145849_e});
                }
                meta = te.func_145832_p();
            }
            te.func_145979_i();
        }
        if (te.field_145992_i == null && te.field_145991_k == null) {
            float adjacentAngle;
            ModelChest model;
            if (te.field_145990_j == null && te.field_145988_l == null) {
                model = smallModel;
                if (this.isChristmas) {
                    this.func_147499_a(christmasNormal);
                } else if ((double)te.field_145989_m >= 0.9) {
                    this.func_147499_a(normalSingleActive);
                } else {
                    this.func_147499_a(normalSingleUnactive);
                }
            } else {
                model = largeModel;
                if (this.isChristmas) {
                    this.func_147499_a(christmasDouble);
                } else if ((double)te.field_145989_m >= 0.9) {
                    this.func_147499_a(normalDoubleActive);
                } else {
                    this.func_147499_a(normalDoubleUnactive);
                }
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            int rotation = 0;
            if (meta == 2) {
                rotation = 180;
            }
            if (meta == 3) {
                rotation = 0;
            }
            if (meta == 4) {
                rotation = 90;
            }
            if (meta == 5) {
                rotation = -90;
            }
            if (meta == 2 && te.field_145990_j != null) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (meta == 5 && te.field_145988_l != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float angle = te.field_145986_n + (te.field_145989_m - te.field_145986_n) * partialTicks;
            if (te.field_145992_i != null && (adjacentAngle = te.field_145992_i.field_145986_n + (te.field_145992_i.field_145989_m - te.field_145992_i.field_145986_n) * partialTicks) > angle) {
                angle = adjacentAngle;
            }
            if (te.field_145991_k != null && (adjacentAngle = te.field_145991_k.field_145986_n + (te.field_145991_k.field_145989_m - te.field_145991_k.field_145986_n) * partialTicks) > angle) {
                angle = adjacentAngle;
            }
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            model.field_78234_a.field_78795_f = -(angle * (float)Math.PI / 2.0f);
            model.func_78231_a();
            GL11.glEnable((int)32826);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTicks) {
        this.renderTileEntityAt((TileEntityChest)te, x, y, z, partialTicks);
    }
}

