/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketManager;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketWall;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedCrystalQuartz;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.packets.PacketCToggleBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocket;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BetterFacing;
import net.geforcemods.securitycraft.util.BlockPos;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.TranslatableString;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBlockPocketManager
extends CustomizableSCTE {
    private static final int CHISELED = 1;
    private static final int PILLAR_Y = 2;
    private static final int PILLAR_X = 3;
    private static final int PILLAR_Z = 4;
    private static final int MG_NORTH = 0;
    private static final int MG_EAST = 1;
    private static final int MG_SOUTH = 2;
    public boolean enabled = false;
    public int size = 5;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();

    public TranslatableString enableMultiblock() {
        if (!this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new PacketCToggleBlockPocketManager(this, true, this.size));
            }
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
            int managerMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            BetterFacing managerFacing = managerMeta == 0 ? BetterFacing.NORTH : (managerMeta == 1 ? BetterFacing.EAST : (managerMeta == 2 ? BetterFacing.SOUTH : BetterFacing.WEST));
            BetterFacing left = managerFacing.rotateY();
            BetterFacing right = left.getOpposite();
            BetterFacing back = left.rotateY();
            boolean lowest = false;
            int highest = this.size - 1;
            BlockPos pos = this.getPos();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            while (BlockUtils.getBlock(this.field_145850_b, pos = pos.offset(left)) instanceof BlockReinforcedCrystalQuartz) {
            }
            pos = pos.offset(right);
            BlockPos startingPos = pos.copy();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.offset(right, xi);
                        Block currentBlock = BlockUtils.getBlock(this.field_145850_b, currentPos);
                        int currentMeta = this.field_145850_b.func_72805_g(currentPos.getX(), currentPos.getY(), currentPos.getZ());
                        if (currentBlock instanceof BlockBlockPocketManager && !currentPos.equals(this.getPos())) {
                            return new TranslatableString("messages.securitycraft:blockpocket.multipleManagers", new Object[0]);
                        }
                        if (yi == 0 && !currentPos.equals(this.getPos()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (!(currentBlock instanceof BlockReinforcedCrystalQuartz) || currentMeta != 1) {
                                    return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                int typeToCheckFor;
                                int n = typeToCheckFor = managerFacing == BetterFacing.NORTH || managerFacing == BetterFacing.SOUTH ? 3 : 4;
                                if (!(currentBlock instanceof BlockReinforcedCrystalQuartz) || currentMeta != typeToCheckFor) {
                                    return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock.pillar", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                int typeToCheckFor;
                                int n = typeToCheckFor = managerFacing == BetterFacing.NORTH || managerFacing == BetterFacing.SOUTH ? 4 : 3;
                                if (!(currentBlock instanceof BlockReinforcedCrystalQuartz) || currentMeta != typeToCheckFor) {
                                    return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock.pillar", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentBlock instanceof BlockBlockPocketWall)) {
                                    return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                                }
                                sides.add(currentPos);
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (!(currentBlock instanceof BlockReinforcedCrystalQuartz) || currentMeta != 2) {
                                return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock.pillar", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentBlock instanceof BlockBlockPocketWall)) {
                                    return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                                }
                                sides.add(currentPos);
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentBlock instanceof BlockBlockPocketWall)) {
                                    return new TranslatableString("messages.securitycraft:blockpocket.invalidBlock", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                                }
                                sides.add(currentPos);
                            }
                        }
                        TileEntityOwnable te = (TileEntityOwnable)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        if (!this.getOwner().owns(te)) {
                            return new TranslatableString("messages.securitycraft:blockpocket.unowned", currentPos, new TranslatableString(currentBlock.func_149694_d(this.field_145850_b, currentPos.getX(), currentPos.getY(), currentPos.getZ()), new Object[0]));
                        }
                        blocks.add(currentPos);
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.up(yi).offset(back, ++zi);
                }
                zi = 0;
                pos = startingPos.up(++yi);
            }
            this.blocks = blocks;
            this.walls = sides;
            this.enabled = true;
            for (BlockPos blockPos : blocks) {
                TileEntity te = this.field_145850_b.func_147438_o(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                if (!(te instanceof TileEntityBlockPocket)) continue;
                ((TileEntityBlockPocket)te).setManager(this);
            }
            this.setWalls(!this.hasModule(EnumCustomModules.DISGUISE));
        }
        return null;
    }

    public void disableMultiblock() {
        if (this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new PacketCToggleBlockPocketManager(this, false, this.size));
            }
            this.enabled = false;
            for (BlockPos pos : this.blocks) {
                TileEntity te = this.field_145850_b.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
                if (!(te instanceof TileEntityBlockPocket)) continue;
                ((TileEntityBlockPocket)te).removeManager();
            }
            if (this.hasModule(EnumCustomModules.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
        }
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            Block block = BlockUtils.getBlock(this.field_145850_b, pos);
            if (!(block instanceof BlockBlockPocketWall)) continue;
            this.field_145850_b.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), seeThrough ? 0 : 1, 2);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.disableMultiblock();
    }

    @Override
    public void onTileEntityDestroyed() {
        super.onTileEntityDestroyed();
        this.disableMultiblock();
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
        if (this.enabled && module == EnumCustomModules.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
        if (this.enabled && module == EnumCustomModules.DISGUISE) {
            this.setWalls(true);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        int i;
        tag.func_74757_a("BlockPocketEnabled", this.enabled);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.func_74772_a("BlocksList" + i, this.blocks.get(i).toLong());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.func_74772_a("WallsList" + i, this.walls.get(i).toLong());
        }
        super.func_145841_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i = 0;
        super.func_145839_a(tag);
        this.enabled = tag.func_74767_n("BlockPocketEnabled");
        while (tag.func_74764_b("BlocksList" + i)) {
            this.blocks.add(BlockPos.fromLong(tag.func_74763_f("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("WallsList" + i)) {
            this.walls.add(BlockPos.fromLong(tag.func_74763_f("WallsList" + i)));
            ++i;
        }
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.DISGUISE, EnumCustomModules.WHITELIST};
    }

    private BlockPos getPos() {
        return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }
}

