/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockPortableRadar;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class TileEntityPortableRadar
extends CustomizableSCTE {
    private Option.OptionDouble searchRadiusOption;
    private Option.OptionInt searchDelayOption;
    private Option.OptionBoolean repeatMessageOption;
    private Option.OptionBoolean enabledOption;
    private boolean shouldSendNewMessage;
    private String lastPlayerName;

    public TileEntityPortableRadar() {
        this.searchRadiusOption = new Option.OptionDouble("searchRadius", SecurityCraft.config.portableRadarSearchRadius, 5.0, 50.0, 5.0);
        this.searchDelayOption = new Option.OptionInt("searchDelay", SecurityCraft.config.portableRadarDelay, 4, 10, 1);
        this.repeatMessageOption = new Option.OptionBoolean("repeatMessage", true);
        this.enabledOption = new Option.OptionBoolean("enabled", true);
        this.shouldSendNewMessage = true;
        this.lastPlayerName = "";
    }

    @Override
    public boolean attackEntity(Entity attacked) {
        if (attacked instanceof EntityPlayer) {
            boolean redstoneModule;
            AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(this.getAttackRange(), this.getAttackRange(), this.getAttackRange());
            List entities = this.field_145850_b.func_72872_a(this.entityTypeToAttack(), area);
            if (entities.isEmpty() && (!(redstoneModule = this.hasModule(EnumCustomModules.REDSTONE)) || redstoneModule && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1)) {
                BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                return false;
            }
            EntityPlayerMP owner = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwner().getName());
            if (owner != null && this.hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, EnumCustomModules.WHITELIST).contains(attacked.func_70005_c_().toLowerCase())) {
                return false;
            }
            if (PlayerUtils.isPlayerOnline(this.getOwner().getName()) && this.shouldSendMessage((EntityPlayer)attacked)) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)owner, StatCollector.func_74838_a((String)"tile.securitycraft:portableRadar.name"), this.hasCustomName() ? StatCollector.func_74838_a((String)"messages.securitycraft:portableRadar.withName").replace("#p", EnumChatFormatting.ITALIC + attacked.func_70005_c_() + EnumChatFormatting.RESET).replace("#n", EnumChatFormatting.ITALIC + this.getCustomName() + EnumChatFormatting.RESET) : StatCollector.func_74838_a((String)"messages.securitycraft:portableRadar.withoutName").replace("#p", EnumChatFormatting.ITALIC + attacked.func_70005_c_() + EnumChatFormatting.RESET).replace("#l", Utils.getFormattedCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e)), EnumChatFormatting.BLUE);
                this.setSentMessage();
            }
            if (this.hasModule(EnumCustomModules.REDSTONE)) {
                BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void attackFailed() {
        if (this.hasModule(EnumCustomModules.REDSTONE)) {
            BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("shouldSendNewMessage", this.shouldSendNewMessage);
        tag.func_74778_a("lastPlayerName", this.lastPlayerName);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("shouldSendNewMessage")) {
            this.shouldSendNewMessage = tag.func_74767_n("shouldSendNewMessage");
        }
        if (tag.func_74764_b("lastPlayerName")) {
            this.lastPlayerName = tag.func_74779_i("lastPlayerName");
        }
    }

    public boolean shouldSendMessage(EntityPlayer player) {
        if (!player.func_70005_c_().equals(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.func_70005_c_();
        }
        return (this.shouldSendNewMessage || this.repeatMessageOption.asBoolean()) && this.enabledOption.asBoolean() && !player.func_70005_c_().equals(this.getOwner().getName());
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean shouldSyncToClient() {
        return false;
    }

    @Override
    public double getAttackRange() {
        return this.searchRadiusOption.asDouble();
    }

    @Override
    public int getTicksBetweenAttacks() {
        return this.searchDelayOption.asInteger() * 20;
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.REDSTONE, EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }
}

