/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;

public enum BetterFacing {
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X);

    private final int index;
    private final int opposite;
    private final int horizontalIndex;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    public static final BetterFacing[] VALUES;
    public static final BetterFacing[] HORIZONTALS;
    private static final Map<String, BetterFacing> NAME_LOOKUP;

    private BetterFacing(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn) {
        this.index = indexIn;
        this.horizontalIndex = horizontalIndexIn;
        this.opposite = oppositeIn;
        this.name = nameIn;
        this.axis = axisIn;
        this.axisDirection = axisDirectionIn;
    }

    public int getIndex() {
        return this.index;
    }

    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public BetterFacing getOpposite() {
        return BetterFacing.byIndex(this.opposite);
    }

    public BetterFacing rotateY() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + (Object)((Object)this));
    }

    public BetterFacing rotateYCCW() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + (Object)((Object)this));
    }

    public int getXOffset() {
        return this.axis == Axis.X ? this.axisDirection.getOffset() : 0;
    }

    public int getYOffset() {
        return this.axis == Axis.Y ? this.axisDirection.getOffset() : 0;
    }

    public int getZOffset() {
        return this.axis == Axis.Z ? this.axisDirection.getOffset() : 0;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public static BetterFacing byIndex(int index) {
        return VALUES[MathHelper.func_76130_a((int)(index % VALUES.length))];
    }

    public float getHorizontalAngle() {
        return (this.horizontalIndex & 3) * 90;
    }

    public String toString() {
        return this.name;
    }

    public static BetterFacing getFacingFromAxis(AxisDirection axisDirectionIn, Axis axisIn) {
        for (BetterFacing BetterFacing2 : BetterFacing.values()) {
            if (BetterFacing2.getAxisDirection() != axisDirectionIn || BetterFacing2.getAxis() != axisIn) continue;
            return BetterFacing2;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirectionIn) + " " + (Object)((Object)axisIn));
    }

    static {
        VALUES = new BetterFacing[6];
        HORIZONTALS = new BetterFacing[4];
        NAME_LOOKUP = Maps.newHashMap();
        BetterFacing[] betterFacingArray = BetterFacing.values();
        int n = betterFacingArray.length;
        for (int i = 0; i < n; ++i) {
            BetterFacing facing;
            BetterFacing.VALUES[facing.index] = facing = betterFacingArray[i];
            if (facing.getAxis().isHorizontal()) {
                BetterFacing.HORIZONTALS[facing.horizontalIndex] = facing;
            }
            NAME_LOOKUP.put(facing.toString().toLowerCase(Locale.ROOT), facing);
        }
    }

    public static enum Plane implements Predicate<BetterFacing>,
    Iterable<BetterFacing>
    {
        HORIZONTAL,
        VERTICAL;


        public BetterFacing[] facings() {
            switch (this) {
                case HORIZONTAL: {
                    return new BetterFacing[]{NORTH, EAST, SOUTH, WEST};
                }
                case VERTICAL: {
                    return new BetterFacing[]{UP, DOWN};
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        public BetterFacing random(Random rand) {
            BetterFacing[] aBetterFacing = this.facings();
            return aBetterFacing[rand.nextInt(aBetterFacing.length)];
        }

        public boolean apply(@Nullable BetterFacing p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<BetterFacing> iterator() {
            return Iterators.forArray((Object[])this.facings());
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int offset;
        private final String description;

        private AxisDirection(int offset, String description) {
            this.offset = offset;
            this.description = description;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Axis implements Predicate<BetterFacing>
    {
        X("x", Plane.HORIZONTAL),
        Y("y", Plane.VERTICAL),
        Z("z", Plane.HORIZONTAL);

        private static final Map<String, Axis> NAME_LOOKUP;
        private final String name;
        private final Plane plane;

        private Axis(String name, Plane plane) {
            this.name = name;
            this.plane = plane;
        }

        @Nullable
        public static Axis byName(String name) {
            return name == null ? null : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
        }

        public String getName2() {
            return this.name;
        }

        public boolean isVertical() {
            return this.plane == Plane.VERTICAL;
        }

        public boolean isHorizontal() {
            return this.plane == Plane.HORIZONTAL;
        }

        public String toString() {
            return this.name;
        }

        public boolean apply(@Nullable BetterFacing p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.getAxis() == this;
        }

        public Plane getPlane() {
            return this.plane;
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_LOOKUP = Maps.newHashMap();
            for (Axis BetterFacing$axis : Axis.values()) {
                NAME_LOOKUP.put(BetterFacing$axis.getName2().toLowerCase(Locale.ROOT), BetterFacing$axis);
            }
        }
    }
}

