/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.geforcemods.securitycraft.util.BetterFacing;
import net.minecraft.util.MathHelper;

public class BlockPos {
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;
    private int x;
    private int y;
    private int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos north(int n) {
        return new BlockPos(this.x, this.y, this.z - n);
    }

    public BlockPos south(int n) {
        return new BlockPos(this.x, this.y, this.z + n);
    }

    public BlockPos east(int n) {
        return new BlockPos(this.x + n, this.y, this.z);
    }

    public BlockPos west(int n) {
        return new BlockPos(this.x - n, this.y, this.z);
    }

    public BlockPos up(int n) {
        return new BlockPos(this.x, this.y + n, this.z);
    }

    public BlockPos down(int n) {
        return new BlockPos(this.x, this.y - n, this.z);
    }

    public BlockPos offset(BetterFacing facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(BetterFacing facing, int n) {
        return n == 0 ? this : new BlockPos(this.getX() + facing.getXOffset() * n, this.getY() + facing.getYOffset() * n, this.getZ() + facing.getZOffset() * n);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int[] asArray() {
        return new int[]{this.x, this.y, this.z};
    }

    public BlockPos copy() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public long toLong() {
        return ((long)this.getX() & X_MASK) << X_SHIFT | ((long)this.getY() & Y_MASK) << Y_SHIFT | ((long)this.getZ() & Z_MASK) << 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockPos) {
            BlockPos pos = (BlockPos)obj;
            return this.x == pos.x && this.y == pos.y && this.z == pos.z;
        }
        return false;
    }

    public static BlockPos fromLong(long serialized) {
        int i = (int)(serialized << 64 - X_SHIFT - NUM_X_BITS >> 64 - NUM_X_BITS);
        int j = (int)(serialized << 64 - Y_SHIFT - NUM_Y_BITS >> 64 - NUM_Y_BITS);
        int k = (int)(serialized << 64 - NUM_Z_BITS >> 64 - NUM_Z_BITS);
        return new BlockPos(i, j, k);
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_SHIFT = 0 + NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
    }
}

