/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Owner {
    public static final DataSerializer<Owner> SERIALIZER = new DataSerializer<Owner>(){

        public void write(PacketBuffer buf, Owner value) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.getName());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.getUUID());
        }

        public Owner read(PacketBuffer buf) throws IOException {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            String uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
            return new Owner(name, uuid);
        }

        public DataParameter<Owner> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }
    };
    private String playerName = "owner";
    private String playerUUID = "ownerUUID";

    public Owner() {
    }

    public Owner(String playerName, String playerUUID) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null) continue;
            String uuid = ownable.getOwner().getUUID();
            String owner = ownable.getOwner().getName();
            if (uuid != null && !uuid.equals(this.playerUUID)) {
                return false;
            }
            if (owner == null || !uuid.equals("ownerUUID") || owner.equals("owner") || owner.equals(this.playerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        String uuid = player.func_146103_bH().getId().toString();
        String owner = player.func_70005_c_();
        if (uuid != null && uuid.equals(this.playerUUID)) {
            return true;
        }
        return owner != null && this.playerUUID.equals("ownerUUID") && owner.equals(this.playerName);
    }

    public void set(String uuid, String name) {
        this.playerName = name;
        this.playerUUID = uuid;
    }

    public void set(Owner newOwner) {
        this.playerName = newOwner.getName();
        this.playerUUID = newOwner.getUUID();
    }

    public void setOwnerName(String name) {
        this.playerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.playerUUID = uuid;
    }

    public String getName() {
        return this.playerName;
    }

    public String getUUID() {
        return this.playerUUID;
    }

    public String toString() {
        return "Name: " + this.playerName + "  UUID: " + this.playerUUID;
    }
}

