/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityAlarm;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAlarm
extends BlockOwnable {
    public final boolean isLit;
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockAlarm(Material material, boolean isLit) {
        super(material);
        this.isLit = isLit;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        if (isLit) {
            this.func_149715_a(1.0f);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) ? true : world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!this.func_176198_a(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        world.func_175684_a(pos, state.func_177230_c(), 1);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            this.playSoundAndUpdate(world, pos);
            world.func_175684_a(pos, state.func_177230_c(), 5);
        }
    }

    public void onNeighborChange(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        World world = (World)w;
        if (world.field_72995_K) {
            return;
        }
        this.playSoundAndUpdate(world, pos);
        EnumFacing enumfacing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        if (!world.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float threePx = 0.1875f;
        float ySideMin = 0.5f - threePx;
        float ySideMax = 0.5f + threePx;
        float hSideMin = 0.5f - threePx;
        float hSideMax = 0.5f + threePx;
        float px = 0.0625f;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (SwitchEnumFacing.FACING_LOOKUP[facing.ordinal()]) {
            case 1: {
                return new AxisAlignedBB(0.0, (double)(ySideMin - px), (double)(hSideMin - px), 0.5, (double)(ySideMax + px), (double)(hSideMax + px));
            }
            case 2: {
                return new AxisAlignedBB(0.5, (double)(ySideMin - px), (double)(hSideMin - px), 1.0, (double)(ySideMax + px), (double)(hSideMax + px));
            }
            case 3: {
                return new AxisAlignedBB((double)(hSideMin - px), (double)(ySideMin - px), 0.0, (double)(hSideMax + px), (double)(ySideMax + px), 0.5);
            }
            case 4: {
                return new AxisAlignedBB((double)(hSideMin - px), (double)(ySideMin - px), 0.5, (double)(hSideMax + px), (double)(ySideMax + px), 1.0);
            }
            case 5: {
                return new AxisAlignedBB((double)(0.5f - threePx - px), 0.0, (double)(0.5f - threePx - px), (double)(0.5f + threePx + px), 0.5, (double)(0.5f + threePx + px));
            }
            case 6: {
                return new AxisAlignedBB((double)(0.5f - threePx - px), 0.5, (double)(0.5f - threePx - px), (double)(0.5f + threePx + px), 1.0, (double)(0.5f + threePx + px));
            }
        }
        return state.func_185900_c(source, pos);
    }

    private void playSoundAndUpdate(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos) instanceof TileEntityAlarm)) {
            return;
        }
        if (world.func_175687_A(pos) > 0) {
            boolean isPowered = ((TileEntityAlarm)world.func_175625_s(pos)).isPowered();
            if (!isPowered) {
                Owner owner = ((TileEntityAlarm)world.func_175625_s(pos)).getOwner();
                EnumFacing dir = BlockUtils.getBlockPropertyAsEnum(world, pos, FACING);
                BlockUtils.setBlock(world, pos, SCContent.alarmLit);
                BlockUtils.setBlockProperty(world, pos, (PropertyEnum)FACING, dir);
                ((TileEntityAlarm)world.func_175625_s(pos)).getOwner().set(owner);
                ((TileEntityAlarm)world.func_175625_s(pos)).setPowered(true);
            }
        } else {
            boolean isPowered = ((TileEntityAlarm)world.func_175625_s(pos)).isPowered();
            if (isPowered) {
                Owner owner = ((TileEntityAlarm)world.func_175625_s(pos)).getOwner();
                EnumFacing dir = BlockUtils.getBlockPropertyAsEnum(world, pos, FACING);
                BlockUtils.setBlock(world, pos, SCContent.alarm);
                BlockUtils.setBlockProperty(world, pos, (PropertyEnum)FACING, dir);
                ((TileEntityAlarm)world.func_175625_s(pos)).getOwner().set(owner);
                ((TileEntityAlarm)world.func_175625_s(pos)).setPowered(false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.alarm));
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)SCContent.alarm);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        switch (meta & 7) {
            case 0: {
                facing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                facing = EnumFacing.EAST;
                break;
            }
            case 2: {
                facing = EnumFacing.WEST;
                break;
            }
            case 3: {
                facing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                facing = EnumFacing.NORTH;
                break;
            }
            default: {
                facing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int meta;
        switch (SwitchEnumFacing.FACING_LOOKUP[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()]) {
            case 1: {
                meta = 1;
                break;
            }
            case 2: {
                meta = 2;
                break;
            }
            case 3: {
                meta = 3;
                break;
            }
            case 4: {
                meta = 4;
                break;
            }
            default: {
                meta = 5;
                break;
            }
            case 6: {
                meta = 0;
            }
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAlarm();
    }

    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

