/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInventoryScannerField
extends BlockContainer
implements IIntersectable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockInventoryScannerField(Material material) {
        super(material);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World world, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        block6: {
            TileEntityInventoryScanner connectedScanner;
            block5: {
                connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
                if (connectedScanner == null) {
                    return;
                }
                if (!(entity instanceof EntityPlayer)) break block5;
                if (ModuleUtils.checkForModule(world, connectedScanner.func_174877_v(), (EntityPlayer)entity, EnumCustomModules.WHITELIST)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < ((EntityPlayer)entity).field_71071_by.field_70462_a.length; ++j) {
                        if (connectedScanner.getStackInSlotCopy(i) == null || ((EntityPlayer)entity).field_71071_by.field_70462_a[j] == null) continue;
                        BlockInventoryScannerField.checkInventory((EntityPlayer)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
                    }
                }
                break block6;
            }
            if (!(entity instanceof EntityItem)) break block6;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i) == null || ((EntityItem)entity).func_92059_d() == null) continue;
                BlockInventoryScannerField.checkEntityItem((EntityItem)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
            }
        }
    }

    public static void checkInventory(EntityPlayer entity, TileEntityInventoryScanner te, ItemStack stack) {
        block4: {
            block3: {
                if (!te.getType().equals("redstone")) break block3;
                for (int i = 1; i <= entity.field_71071_by.field_70462_a.length; ++i) {
                    if (entity.field_71071_by.field_70462_a[i - 1] == null || (!te.hasModule(EnumCustomModules.SMART) || !BlockInventoryScannerField.areItemStacksEqual(entity.field_71071_by.field_70462_a[i - 1], stack) || !ItemStack.func_77970_a((ItemStack)entity.field_71071_by.field_70462_a[i - 1], (ItemStack)stack)) && (te.hasModule(EnumCustomModules.SMART) || entity.field_71071_by.field_70462_a[i - 1].func_77973_b() != stack.func_77973_b())) continue;
                    BlockInventoryScannerField.updateInventoryScannerPower(te);
                }
                break block4;
            }
            if (!te.getType().equals("check")) break block4;
            for (int i = 1; i <= entity.field_71071_by.field_70462_a.length; ++i) {
                if (entity.field_71071_by.field_70462_a[i - 1] == null || (!te.hasModule(EnumCustomModules.SMART) || !BlockInventoryScannerField.areItemStacksEqual(entity.field_71071_by.field_70462_a[i - 1], stack) || !ItemStack.func_77970_a((ItemStack)entity.field_71071_by.field_70462_a[i - 1], (ItemStack)stack)) && (te.hasModule(EnumCustomModules.SMART) || entity.field_71071_by.field_70462_a[i - 1].func_77973_b() != stack.func_77973_b())) continue;
                if (te.hasModule(EnumCustomModules.STORAGE)) {
                    te.addItemToStorage(entity.field_71071_by.field_70462_a[i - 1]);
                }
                entity.field_71071_by.field_70462_a[i - 1] = null;
            }
        }
    }

    public static void checkEntityItem(EntityItem entity, TileEntityInventoryScanner te, ItemStack stack) {
        if (te.getType().equals("redstone")) {
            if (te.hasModule(EnumCustomModules.SMART) && BlockInventoryScannerField.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !te.hasModule(EnumCustomModules.SMART) && entity.func_92059_d().func_77973_b() == stack.func_77973_b()) {
                BlockInventoryScannerField.updateInventoryScannerPower(te);
            }
        } else if (te.getType().equals("check") && (te.hasModule(EnumCustomModules.SMART) && BlockInventoryScannerField.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !te.hasModule(EnumCustomModules.SMART) && entity.func_92059_d().func_77973_b() == stack.func_77973_b())) {
            if (te.hasModule(EnumCustomModules.STORAGE)) {
                te.addItemToStorage(entity.func_92059_d());
            }
            entity.func_70106_y();
        }
    }

    public static void updateInventoryScannerPower(TileEntityInventoryScanner te) {
        if (!te.shouldProvidePower()) {
            te.setShouldProvidePower(true);
        }
        SecurityCraft.log("Running te update");
        te.setCooldown(60);
        BlockInventoryScannerField.checkAndUpdateTEAppropriately(te);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c(), 1, true);
        SecurityCraft.log("Emitting redstone on the " + FMLCommonHandler.instance().getEffectiveSide() + " side. (te coords: " + Utils.getFormattedCoordinates(te.func_174877_v()));
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.func_77946_l();
        ItemStack s2 = stack2.func_77946_l();
        s1.field_77994_a = 1;
        s2.field_77994_a = 1;
        return ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
    }

    private static void checkAndUpdateTEAppropriately(TileEntityInventoryScanner te) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(te.func_145831_w(), te.func_174877_v());
        if (connectedScanner == null) {
            return;
        }
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145838_q(), 1, true);
        connectedScanner.setShouldProvidePower(true);
        connectedScanner.setCooldown(60);
        BlockUtils.updateAndNotify(connectedScanner.func_145831_w(), connectedScanner.func_174877_v(), connectedScanner.func_145838_q(), 1, true);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int j;
            int i;
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(world, pos.func_177985_f(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177985_f(j), false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(world, pos.func_177965_g(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177965_g(j), false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(world, pos.func_177964_d(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177964_d(j), false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(world, pos.func_177970_e(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177970_e(j), false);
                }
                break;
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST || source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            return new AxisAlignedBB(0.0, 0.0, (double)0.4f, 1.0, 1.0, (double)0.6f);
        }
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH || source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)0.4f, 0.0, 0.0, (double)0.6f, 1.0, 1.0);
        }
        return state.func_185900_c(source, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySCTE().intersectsEntities();
    }
}

