/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.items.ItemKeycardBase;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockKeycardReader
extends BlockOwnable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockKeycardReader(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public void insertCard(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        if (ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.BLACKLIST)) {
            return;
        }
        int requiredLevel = -1;
        int cardLvl = ((ItemKeycardBase)stack.func_77973_b()).getKeycardLvl(stack);
        if (((TileEntityKeycardReader)world.func_175625_s(pos)).getPassword() != null) {
            requiredLevel = Integer.parseInt(((TileEntityKeycardReader)world.func_175625_s(pos)).getPassword());
        }
        if (!((TileEntityKeycardReader)world.func_175625_s(pos)).doesRequireExactKeycard() && requiredLevel <= cardLvl || ((TileEntityKeycardReader)world.func_175625_s(pos)).doesRequireExactKeycard() && requiredLevel == cardLvl) {
            if (cardLvl == 6 && stack.func_77978_p() != null && !player.field_71075_bZ.field_75098_d) {
                stack.func_77978_p().func_74768_a("Uses", stack.func_77978_p().func_74762_e("Uses") - 1);
                if (stack.func_77978_p().func_74762_e("Uses") <= 0) {
                    --stack.field_77994_a;
                }
            }
            BlockKeycardReader.activate(world, pos);
        }
        if (!world.field_72995_K) {
            if (requiredLevel != -1 && ((TileEntityKeycardReader)world.func_175625_s(pos)).doesRequireExactKeycard() && requiredLevel != cardLvl) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keycardReader.name", new Object[0]), ClientUtils.localize("messages.securitycraft:keycardReader.required", new Object[0]).replace("#r", ((IPasswordProtected)world.func_175625_s(pos)).getPassword()).replace("#c", "" + cardLvl), TextFormatting.RED);
            } else if (requiredLevel == -1) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keycardReader.name", new Object[0]), ClientUtils.localize("messages.securitycraft:keycardReader.notSet", new Object[0]), TextFormatting.RED);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.field_71071_by.func_70448_g() == null || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemKeycardBase) && player.field_71071_by.func_70448_g().func_77973_b() != SCContent.adminTool) {
            ((TileEntityKeycardReader)world.func_175625_s(pos)).openPasswordGUI(player);
        } else if (player.field_71071_by.func_70448_g().func_77973_b() == SCContent.adminTool) {
            ((BlockKeycardReader)BlockUtils.getBlock(world, pos)).insertCard(world, pos, new ItemStack(SCContent.limitedUseKeycard, 1), player);
        } else {
            ((BlockKeycardReader)BlockUtils.getBlock(world, pos)).insertCard(world, pos, player.field_71071_by.func_70448_g(), player);
        }
        return false;
    }

    public static void activate(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, POWERED, true);
        world.func_175685_c(pos, SCContent.keycardReader);
        world.func_175684_a(pos, SCContent.keycardReader, 60);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random par5Random) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, POWERED, false);
            world.func_175685_c(pos, SCContent.keycardReader);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_175688_a(EnumParticleTypes.REDSTONE, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeycardReader();
    }
}

