/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockFrame;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.compat.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockKeypad
extends BlockContainer
implements ICustomWailaDisplay,
IPasswordConvertible {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockKeypad(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityKeypad && ((TileEntityKeypad)te).hasModule(EnumCustomModules.DISGUISE)) {
            ItemStack module = ((TileEntityKeypad)te).getModule(EnumCustomModules.DISGUISE);
            IBlockState disguisedState = ((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).get(0).func_176223_P();
            return disguisedState.func_177230_c().isSideSolid(disguisedState, world, pos, side);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block blockToDisguiseAs;
        ItemStack disguiseModule;
        ArrayList<Block> blocks;
        if (world.func_175625_s(pos) == null) {
            return true;
        }
        CustomizableSCTE tileEntity = (CustomizableSCTE)world.func_175625_s(pos);
        if (!(!tileEntity.hasModule(EnumCustomModules.DISGUISE) || (blocks = ((ItemModule)(disguiseModule = tileEntity.getModule(EnumCustomModules.DISGUISE)).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() == 0 || (blockToDisguiseAs = (Block)blocks.get(0)).func_149662_c(blockToDisguiseAs.func_176223_P()) && blockToDisguiseAs.func_149686_d(blockToDisguiseAs.func_176223_P()))) {
            return this.checkForSideTransparency(world, pos, world.func_180495_p(pos.func_177972_a(side)).func_177230_c(), side);
        }
        return true;
    }

    public boolean checkForSideTransparency(IBlockAccess world, BlockPos keypadPos, Block neighborBlock, EnumFacing side) {
        if (neighborBlock == Blocks.field_150350_a) {
            return true;
        }
        return !(neighborBlock instanceof BlockBreakable) || !neighborBlock.toString().replace("Block{", "").startsWith("minecraft:");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return false;
        }
        if (ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.BLACKLIST)) {
            BlockKeypad.activate(world, pos);
            return true;
        }
        if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker) && !PlayerUtils.isHoldingItem(player, SCContent.keyPanel)) {
            ((IPasswordProtected)world.func_175625_s(pos)).openPasswordGUI(player);
        }
        return true;
    }

    public static void activate(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, POWERED, true);
        world.func_175685_c(pos, SCContent.keypad);
        world.func_175684_a(pos, SCContent.keypad, 60);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        BlockUtils.setBlockProperty(world, pos, POWERED, false);
        world.func_175685_c(pos, SCContent.keypad);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 15) {
            return this.func_176223_P();
        }
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)POWERED) && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        if (!state.func_177228_b().containsKey((Object)FACING)) {
            return 15;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public IBlockState getDisguisedBlockState(IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityKeypad) {
            ItemStack module;
            TileEntityKeypad te = (TileEntityKeypad)world.func_175625_s(pos);
            ItemStack itemStack = module = te.hasModule(EnumCustomModules.DISGUISE) ? te.getModule(EnumCustomModules.DISGUISE) : null;
            if (module != null && !((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).isEmpty()) {
                ItemStack disguisedStack = ((ItemModule)module.func_77973_b()).getAddons(module.func_77978_p()).get(0);
                Block block = Block.func_149634_a((Item)disguisedStack.func_77973_b());
                boolean hasMeta = disguisedStack.func_77981_g();
                IBlockState disguisedModel = block.func_176203_a(hasMeta ? disguisedStack.func_77952_i() : this.func_176201_c(world.func_180495_p(pos)));
                if (block != this) {
                    return disguisedModel.func_185899_b(world, pos);
                }
            }
        }
        return null;
    }

    public ItemStack getDisguisedStack(IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityKeypad) {
            ItemStack disguisedStack;
            ItemStack stack;
            TileEntityKeypad te = (TileEntityKeypad)world.func_175625_s(pos);
            ItemStack itemStack = stack = te.hasModule(EnumCustomModules.DISGUISE) ? te.getModule(EnumCustomModules.DISGUISE) : null;
            if (stack != null && !((ItemModule)stack.func_77973_b()).getBlockAddons(stack.func_77978_p()).isEmpty() && Block.func_149634_a((Item)(disguisedStack = ((ItemModule)stack.func_77973_b()).getAddons(stack.func_77978_p()).get(0)).func_77973_b()) != this) {
                return disguisedStack;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeypad();
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        ItemStack stack = this.getDisguisedStack((IBlockAccess)world, pos);
        return stack != null ? stack : new ItemStack((Block)this);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos) == null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = this.getDisguisedStack((IBlockAccess)world, pos);
        return stack == null ? new ItemStack((Block)this) : stack;
    }

    @Override
    public Block getOriginalBlock() {
        return SCContent.frame;
    }

    @Override
    public boolean convert(EntityPlayer player, World world, BlockPos pos) {
        world.func_175656_a(pos, SCContent.keypad.func_176223_P().func_177226_a((IProperty)FACING, world.func_180495_p(pos).func_177229_b((IProperty)BlockFrame.FACING)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        ((IOwnable)world.func_175625_s(pos)).getOwner().set(((IOwnable)world.func_175625_s(pos)).getOwner());
        return true;
    }
}

