/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMine
extends BlockExplosive {
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BlockMine(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        this.explode((World)world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151592_s && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151570_A && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151579_a && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151568_F && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151585_k;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            if (player != null && player.field_71075_bZ.field_75098_d && !SecurityCraft.config.mineExplodesWhenInCreative) {
                return super.removedByPlayer(state, world, pos, player, willHarvest);
            }
            this.explode(world, pos);
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float f = 0.2f;
        float g = 0.1f;
        return BlockUtils.fromBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, g * 2.0f / 2.0f + 0.1f, 0.5f + f);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof EntityCreeper || entity instanceof EntityOcelot || entity instanceof EntityEnderman || entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175655_b(pos, false);
            if (SecurityCraft.config.smallerMineExplosion) {
                world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, true);
            } else {
                world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.0f, true);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int meta) {
        return Item.func_150898_a((Block)SCContent.mine);
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.mine));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable();
    }
}

