/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.compat.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReinforcedPurpur
extends BlockOwnable
implements ICustomWailaDisplay,
IReinforcedBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockReinforcedPurpur() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.DEFAULT)));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return !(entity instanceof EntityWither);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (meta == EnumType.LINES_Y.getMetadata()) {
            switch (facing.func_176740_k()) {
                case Z: {
                    return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.LINES_Z));
                }
                case X: {
                    return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.LINES_X));
                }
                case Y: {
                    return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.LINES_Y));
                }
            }
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.DEFAULT));
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        return type != EnumType.LINES_X && type != EnumType.LINES_Z ? type.getMetadata() : EnumType.LINES_Y.getMetadata();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        return type != EnumType.LINES_X && type != EnumType.LINES_Z ? super.func_180643_i(state) : new ItemStack(Item.func_150898_a((Block)this), 1, EnumType.LINES_Y.getMetadata());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, EnumType.DEFAULT.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.LINES_Y.getMetadata()));
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151677_p;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
                    case LINES_X: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.LINES_Z));
                    }
                    case LINES_Z: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.LINES_X));
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            EnumType next;
            if (!prop.func_177701_a().equals("variant") || prop.func_177699_b() != EnumType.class) continue;
            EnumType current = (EnumType)((Object)state.func_177229_b(prop));
            EnumType enumType = current == EnumType.LINES_X ? EnumType.LINES_Y : (current == EnumType.LINES_Y ? EnumType.LINES_Z : (next = current == EnumType.LINES_Z ? EnumType.LINES_X : current));
            if (next == current) {
                return false;
            }
            world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((Object)next)));
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedPurpur), 1, BlockUtils.getBlockMeta(world, pos) != 0 ? 1 : 0);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return true;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_185767_cT, Blocks.field_185768_cU);
    }

    @Override
    public int getAmount() {
        return 2;
    }

    public static enum EnumType implements IStringSerializable
    {
        DEFAULT(0, "default", "default"),
        LINES_Y(1, "lines_y", "lines"),
        LINES_X(2, "lines_x", "lines"),
        LINES_Z(3, "lines_z", "lines");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String serializedName;
        private final String unlocalizedName;

        private EnumType(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.serializedName = name;
            this.unlocalizedName = unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.serializedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.META_LOOKUP[value.getMetadata()] = value = enumTypeArray[i];
            }
        }
    }
}

