/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSUpdateTEOwnable
implements IMessage {
    private BlockPos pos;
    private String name;
    private String uuid;
    private boolean customizable;
    private byte cameraDown;
    NBTTagCompound tag;

    public PacketSUpdateTEOwnable() {
    }

    public PacketSUpdateTEOwnable(TileEntityOwnable te) {
        this(te.func_174877_v(), te.getOwner().getName(), te.getOwner().getUUID(), te instanceof CustomizableSCTE, te instanceof CustomizableSCTE ? ((CustomizableSCTE)te).func_189515_b(new NBTTagCompound()) : null, (byte)(te instanceof TileEntitySecurityCamera ? (te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockSecurityCamera.FACING) == EnumFacing.DOWN ? 2 : 1) : 0));
    }

    public PacketSUpdateTEOwnable(BlockPos pos, String name, String uuid, boolean customizable, NBTTagCompound tag, byte cameraDown) {
        this.pos = pos;
        this.name = name;
        this.uuid = uuid;
        this.customizable = customizable;
        this.tag = tag;
        this.cameraDown = cameraDown;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        buf.writeBoolean(this.customizable);
        if (this.customizable) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
        buf.writeByte((int)this.cameraDown);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.customizable = buf.readBoolean();
        if (this.customizable) {
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
        this.cameraDown = buf.readByte();
    }

    public static class Handler
    implements IMessageHandler<PacketSUpdateTEOwnable, IMessage> {
        public IMessage onMessage(PacketSUpdateTEOwnable message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                if (te == null || !(te instanceof IOwnable)) {
                    return;
                }
                ((IOwnable)te).setOwner(message.uuid, message.name);
                if (message.customizable) {
                    ((CustomizableSCTE)te).func_145839_a(message.tag);
                }
                if (message.cameraDown > 0) {
                    ((TileEntitySecurityCamera)te).down = message.cameraDown == 2;
                }
            });
            return null;
        }
    }
}

