/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetBlock
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int meta;
    private String blockID;

    public PacketSetBlock() {
    }

    public PacketSetBlock(int x, int y, int z, String id, int meta) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockID = id;
        this.meta = meta;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.blockID);
        buf.writeInt(this.meta);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.blockID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.meta = buf.readInt();
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSetBlock, IMessage> {
        public IMessage onMessage(PacketSetBlock message, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                int x = message.x;
                int y = message.y;
                int z = message.z;
                BlockPos pos = BlockUtils.toPos(x, y, z);
                String blockID = message.blockID;
                int meta = message.meta;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                World world = this.getWorld((EntityPlayer)player);
                TileEntity te = world.func_175625_s(pos);
                ItemStack[] modules = null;
                ItemStack[] inventory = null;
                int[] times = new int[4];
                String password = "";
                Owner owner = null;
                if (te instanceof CustomizableSCTE) {
                    modules = ((CustomizableSCTE)te).itemStacks;
                }
                if (te instanceof TileEntityKeypadFurnace) {
                    inventory = ((TileEntityKeypadFurnace)te).furnaceItemStacks;
                    times[0] = ((TileEntityKeypadFurnace)te).furnaceBurnTime;
                    times[1] = ((TileEntityKeypadFurnace)te).currentItemBurnTime;
                    times[2] = ((TileEntityKeypadFurnace)te).cookTime;
                    times[3] = ((TileEntityKeypadFurnace)te).totalCookTime;
                }
                if (te instanceof TileEntityOwnable && ((TileEntityOwnable)te).getOwner() != null) {
                    owner = ((TileEntityOwnable)te).getOwner();
                }
                if (te instanceof TileEntityKeypadChest && ((TileEntityKeypadChest)te).getPassword() != null) {
                    password = ((TileEntityKeypadChest)te).getPassword();
                }
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockID));
                this.getWorld((EntityPlayer)player).func_175656_a(pos, meta >= 0 ? block.func_176203_a(meta) : block.func_176203_a(0));
                if (modules != null) {
                    ((CustomizableSCTE)te).itemStacks = modules;
                }
                if (inventory != null && te instanceof TileEntityKeypadFurnace) {
                    ((TileEntityKeypadFurnace)te).furnaceItemStacks = inventory;
                    ((TileEntityKeypadFurnace)te).furnaceBurnTime = times[0];
                    ((TileEntityKeypadFurnace)te).currentItemBurnTime = times[1];
                    ((TileEntityKeypadFurnace)te).cookTime = times[2];
                    ((TileEntityKeypadFurnace)te).totalCookTime = times[3];
                }
                if (owner != null) {
                    ((TileEntityOwnable)te).getOwner().set(owner.getUUID(), owner.getName());
                }
                if (!password.isEmpty() && te instanceof TileEntityKeypadChest) {
                    ((TileEntityKeypadChest)te).setPassword(password);
                }
                if (te instanceof TileEntitySecurityCamera) {
                    world.func_175685_c(pos.func_177967_a((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), world.func_180495_p(pos).func_177230_c());
                }
            });
            return null;
        }
    }
}

