/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityPortableRadar;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUtils {
    public static void setBlockInBox(World world, int x, int y, int z, Block block) {
        BlockUtils.setBlock(world, x + 1, y + 1, z, block);
        BlockUtils.setBlock(world, x + 1, y + 2, z, block);
        BlockUtils.setBlock(world, x + 1, y + 3, z, block);
        BlockUtils.setBlock(world, x + 1, y + 1, z + 1, block);
        BlockUtils.setBlock(world, x + 1, y + 2, z + 1, block);
        BlockUtils.setBlock(world, x + 1, y + 3, z + 1, block);
        BlockUtils.setBlock(world, x - 1, y + 1, z, block);
        BlockUtils.setBlock(world, x - 1, y + 2, z, block);
        BlockUtils.setBlock(world, x - 1, y + 3, z, block);
        BlockUtils.setBlock(world, x - 1, y + 1, z + 1, block);
        BlockUtils.setBlock(world, x - 1, y + 2, z + 1, block);
        BlockUtils.setBlock(world, x - 1, y + 3, z + 1, block);
        BlockUtils.setBlock(world, x, y + 1, z + 1, block);
        BlockUtils.setBlock(world, x, y + 2, z + 1, block);
        BlockUtils.setBlock(world, x, y + 3, z + 1, block);
        BlockUtils.setBlock(world, x + 1, y + 1, z, block);
        BlockUtils.setBlock(world, x + 1, y + 2, z, block);
        BlockUtils.setBlock(world, x + 1, y + 3, z, block);
        BlockUtils.setBlock(world, x, y + 1, z - 1, block);
        BlockUtils.setBlock(world, x, y + 2, z - 1, block);
        BlockUtils.setBlock(world, x, y + 3, z - 1, block);
        BlockUtils.setBlock(world, x + 1, y + 1, z - 1, block);
        BlockUtils.setBlock(world, x + 1, y + 2, z - 1, block);
        BlockUtils.setBlock(world, x + 1, y + 3, z - 1, block);
        BlockUtils.setBlock(world, x - 1, y + 1, z - 1, block);
        BlockUtils.setBlock(world, x - 1, y + 2, z - 1, block);
        BlockUtils.setBlock(world, x - 1, y + 3, z - 1, block);
        BlockUtils.setBlock(world, x + 1, y + 4, z + 1, block);
        BlockUtils.setBlock(world, x + 1, y + 4, z - 1, block);
        BlockUtils.setBlock(world, x - 1, y + 4, z + 1, block);
        BlockUtils.setBlock(world, x - 1, y + 4, z - 1, block);
    }

    public static void updateAndNotify(World world, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.func_175684_a(pos, block, delay);
        }
        world.func_180496_d(pos.func_177974_f(), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177976_e(), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177968_d(), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177978_c(), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177984_a(), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177977_b(), world.func_180495_p(pos).func_177230_c());
    }

    public static void destroyBlock(World world, BlockPos pos, boolean dropBlock) {
        world.func_175655_b(pos, dropBlock);
    }

    public static int getBlockMeta(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
    }

    public static void setBlock(World world, BlockPos pos, Block block) {
        world.func_175656_a(pos, block.func_176223_P());
    }

    public static void setBlock(World world, int x, int y, int z, Block block) {
        BlockUtils.setBlock(world, BlockUtils.toPos(x, y, z), block);
    }

    public static Block getBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_180495_p(BlockUtils.toPos(x, y, z)).func_177230_c();
    }

    public static void setBlockProperty(World world, BlockPos pos, PropertyBool property, boolean value) {
        BlockUtils.setBlockProperty(world, pos, property, value, false);
    }

    public static void setBlockProperty(World world, BlockPos pos, PropertyBool property, boolean value, boolean retainOldTileEntity) {
        if (retainOldTileEntity) {
            ItemStack[] modules = null;
            ItemStack[] inventory = null;
            int[] times = new int[4];
            String password = "";
            Owner owner = null;
            int cooldown = -1;
            if (world.func_175625_s(pos) instanceof CustomizableSCTE) {
                modules = ((CustomizableSCTE)world.func_175625_s((BlockPos)pos)).itemStacks;
            }
            if (world.func_175625_s(pos) instanceof TileEntityKeypadFurnace) {
                inventory = ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).furnaceItemStacks;
                times[0] = ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).furnaceBurnTime;
                times[1] = ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).currentItemBurnTime;
                times[2] = ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).cookTime;
                times[3] = ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).totalCookTime;
            }
            if (world.func_175625_s(pos) instanceof TileEntityOwnable && ((TileEntityOwnable)world.func_175625_s(pos)).getOwner() != null) {
                owner = ((TileEntityOwnable)world.func_175625_s(pos)).getOwner();
            }
            if (world.func_175625_s(pos) instanceof TileEntityKeypad && ((TileEntityKeypad)world.func_175625_s(pos)).getPassword() != null) {
                password = ((TileEntityKeypad)world.func_175625_s(pos)).getPassword();
            }
            if (world.func_175625_s(pos) instanceof TileEntityKeypadFurnace && ((TileEntityKeypadFurnace)world.func_175625_s(pos)).getPassword() != null) {
                password = ((TileEntityKeypadFurnace)world.func_175625_s(pos)).getPassword();
            }
            if (world.func_175625_s(pos) instanceof TileEntityKeypadChest && ((TileEntityKeypadChest)world.func_175625_s(pos)).getPassword() != null) {
                password = ((TileEntityKeypadChest)world.func_175625_s(pos)).getPassword();
            }
            if (world.func_175625_s(pos) instanceof TileEntityPortableRadar && ((TileEntityPortableRadar)world.func_175625_s(pos)).getAttackCooldown() != 0) {
                cooldown = ((TileEntityPortableRadar)world.func_175625_s(pos)).getAttackCooldown();
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)property, (Comparable)Boolean.valueOf(value)));
            world.func_175690_a(pos, tileEntity);
            if (modules != null) {
                ((CustomizableSCTE)world.func_175625_s((BlockPos)pos)).itemStacks = modules;
            }
            if (inventory != null && world.func_175625_s(pos) instanceof TileEntityKeypadFurnace) {
                ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).furnaceItemStacks = inventory;
                ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).furnaceBurnTime = times[0];
                ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).currentItemBurnTime = times[1];
                ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).cookTime = times[2];
                ((TileEntityKeypadFurnace)world.func_175625_s((BlockPos)pos)).totalCookTime = times[3];
            }
            if (owner != null) {
                ((TileEntityOwnable)world.func_175625_s(pos)).getOwner().set(owner);
            }
            if (!password.isEmpty() && world.func_175625_s(pos) instanceof TileEntityKeypad) {
                ((TileEntityKeypad)world.func_175625_s(pos)).setPassword(password);
            }
            if (!password.isEmpty() && world.func_175625_s(pos) instanceof TileEntityKeypadFurnace) {
                ((TileEntityKeypadFurnace)world.func_175625_s(pos)).setPassword(password);
            }
            if (!password.isEmpty() && world.func_175625_s(pos) instanceof TileEntityKeypadChest) {
                ((TileEntityKeypadChest)world.func_175625_s(pos)).setPassword(password);
            }
            if (cooldown != -1 && world.func_175625_s(pos) instanceof TileEntityPortableRadar) {
                ((TileEntityPortableRadar)world.func_175625_s(pos)).setAttackCooldown(cooldown);
            }
        } else {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)property, (Comparable)Boolean.valueOf(value)));
        }
    }

    public static void setBlockProperty(World world, BlockPos pos, PropertyInteger property, int value) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)property, (Comparable)Integer.valueOf(value)));
    }

    public static void setBlockProperty(World world, BlockPos pos, PropertyEnum property, EnumFacing value) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)property, (Comparable)value));
    }

    public static boolean hasBlockProperty(World world, BlockPos pos, IProperty<?> property) {
        try {
            world.func_180495_p(pos).func_177229_b(property);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean getBlockPropertyAsBoolean(World world, BlockPos pos, PropertyBool property) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)property);
    }

    public static int getBlockPropertyAsInteger(World world, BlockPos pos, PropertyInteger property) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)property);
    }

    public static EnumFacing getBlockPropertyAsEnum(World world, BlockPos pos, PropertyEnum<?> property) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b(property);
    }

    public static EnumFacing getBlockPropertyAsEnum(IBlockAccess world, BlockPos pos, PropertyEnum<?> property) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b(property);
    }

    public static EnumFacing getBlockProperty(World world, BlockPos pos, PropertyDirection property) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)property);
    }

    public static Material getBlockMaterial(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a();
    }

    public static AxisAlignedBB fromBounds(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d6 = Math.min(x1, x2);
        double d7 = Math.min(y1, y2);
        double d8 = Math.min(z1, z2);
        double d9 = Math.max(x1, x2);
        double d10 = Math.max(y1, y2);
        double d11 = Math.max(z1, z2);
        return new AxisAlignedBB(d6, d7, d8, d9, d10, d11);
    }

    public static BlockPos toPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static int[] fromPos(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static boolean hasActiveSCBlockNextTo(World world, BlockPos pos) {
        return BlockUtils.hasActiveLaserNextTo(world, pos) || BlockUtils.hasActiveScannerNextTo(world, pos) || BlockUtils.hasActiveKeypadNextTo(world, pos) || BlockUtils.hasActiveReaderNextTo(world, pos) || BlockUtils.hasActiveInventoryScannerNextTo(world, pos);
    }

    public static boolean hasActiveLaserNextTo(World world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177977_b())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        return false;
    }

    public static boolean hasActiveScannerNextTo(World world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177977_b())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        return false;
    }

    public static boolean hasActiveKeypadNextTo(World world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)world.func_175625_s(pos.func_177977_b())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        return false;
    }

    public static boolean hasActiveReaderNextTo(World world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)world.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)world.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)world.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)world.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177984_a(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177977_b(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)world.func_175625_s(pos.func_177977_b())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        return false;
    }

    public static boolean hasActiveInventoryScannerNextTo(World world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177974_f())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177974_f())).shouldProvidePower()) {
            return ((IOwnable)world.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177976_e())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177976_e())).shouldProvidePower()) {
            return ((IOwnable)world.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177968_d())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177968_d())).shouldProvidePower()) {
            return ((IOwnable)world.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177978_c())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177978_c())).shouldProvidePower()) {
            return ((IOwnable)world.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177984_a()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177984_a())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177984_a())).shouldProvidePower()) {
            return ((IOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(world, pos.func_177977_b()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177977_b())).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_175625_s(pos.func_177977_b())).shouldProvidePower()) {
            return ((IOwnable)world.func_175625_s(pos.func_177977_b())).getOwner().owns((IOwnable)world.func_175625_s(pos));
        }
        return false;
    }
}

