/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ModuleUtils {
    public static void checkForBlockAndInsertModule(World world, BlockPos pos, String dir, Block blockToCheckFor, int range, ItemStack module, boolean updateAdjacentBlocks) {
        for (int i = 1; i <= range; ++i) {
            if (dir.equalsIgnoreCase("x+")) {
                if (world.func_180495_p(pos.func_177965_g(i)).func_177230_c() != blockToCheckFor || ((CustomizableSCTE)world.func_175625_s(pos.func_177965_g(i))).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177965_g(i))).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, pos.func_177965_g(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("x-")) {
                if (world.func_180495_p(pos.func_177985_f(i)).func_177230_c() != blockToCheckFor || ((CustomizableSCTE)world.func_175625_s(pos.func_177985_f(i))).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177985_f(i))).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, pos.func_177985_f(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y+")) {
                if (world.func_180495_p(pos.func_177981_b(i)).func_177230_c() != blockToCheckFor || ((CustomizableSCTE)world.func_175625_s(pos.func_177981_b(i))).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177981_b(i))).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, pos.func_177981_b(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y-")) {
                if (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() != blockToCheckFor || ((CustomizableSCTE)world.func_175625_s(pos.func_177979_c(i))).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177979_c(i))).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, pos.func_177979_c(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("z+")) {
                if (world.func_180495_p(pos.func_177970_e(i)).func_177230_c() != blockToCheckFor || ((CustomizableSCTE)world.func_175625_s(pos.func_177970_e(i))).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177970_e(i))).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, pos.func_177970_e(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (!dir.equalsIgnoreCase("z-") || world.func_180495_p(pos.func_177964_d(i)).func_177230_c() != blockToCheckFor || ((CustomizableSCTE)world.func_175625_s(pos.func_177964_d(i))).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
            ((CustomizableSCTE)world.func_175625_s(pos.func_177964_d(i))).insertModule(module);
            if (!updateAdjacentBlocks) continue;
            ModuleUtils.checkInAllDirsAndInsertModule(world, pos.func_177964_d(i), blockToCheckFor, range, module, updateAdjacentBlocks);
        }
    }

    public static void checkInAllDirsAndInsertModule(World world, BlockPos pos, Block blockToCheckFor, int range, ItemStack module, boolean updateAdjacentBlocks) {
        ModuleUtils.checkForBlockAndInsertModule(world, pos, "x+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, pos, "x-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, pos, "y+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, pos, "y-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, pos, "z+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, pos, "z-", blockToCheckFor, range, module, updateAdjacentBlocks);
    }

    public static void checkForBlockAndRemoveModule(World world, BlockPos pos, String dir, Block blockToCheckFor, int range, EnumCustomModules module, boolean updateAdjacentBlocks) {
        for (int i = 1; i <= range; ++i) {
            if (dir.equalsIgnoreCase("x+")) {
                if (world.func_180495_p(pos.func_177965_g(i)).func_177230_c() != blockToCheckFor || !((CustomizableSCTE)world.func_175625_s(pos.func_177965_g(i))).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177965_g(i))).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, pos.func_177965_g(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("x-")) {
                if (world.func_180495_p(pos.func_177985_f(i)).func_177230_c() != blockToCheckFor || !((CustomizableSCTE)world.func_175625_s(pos.func_177985_f(i))).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177985_f(i))).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, pos.func_177985_f(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y+")) {
                if (world.func_180495_p(pos.func_177981_b(i)).func_177230_c() != blockToCheckFor || !((CustomizableSCTE)world.func_175625_s(pos.func_177981_b(i))).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177981_b(i))).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, pos.func_177981_b(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y-")) {
                if (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() != blockToCheckFor || !((CustomizableSCTE)world.func_175625_s(pos.func_177979_c(i))).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177979_c(i))).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, pos.func_177979_c(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("z+")) {
                if (world.func_180495_p(pos.func_177970_e(i)).func_177230_c() != blockToCheckFor || !((CustomizableSCTE)world.func_175625_s(pos.func_177970_e(i))).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_175625_s(pos.func_177970_e(i))).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, pos.func_177970_e(i), blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (!dir.equalsIgnoreCase("z-") || world.func_180495_p(pos.func_177964_d(i)).func_177230_c() != blockToCheckFor || !((CustomizableSCTE)world.func_175625_s(pos.func_177964_d(i))).hasModule(module)) continue;
            ((CustomizableSCTE)world.func_175625_s(pos.func_177964_d(i))).removeModule(module);
            if (!updateAdjacentBlocks) continue;
            ModuleUtils.checkInAllDirsAndRemoveModule(world, pos.func_177964_d(i), blockToCheckFor, range, module, updateAdjacentBlocks);
        }
    }

    public static void checkInAllDirsAndRemoveModule(World world, BlockPos pos, Block blockToCheckFor, int range, EnumCustomModules module, boolean updateAdjacentBlocks) {
        ModuleUtils.checkForBlockAndRemoveModule(world, pos, "x+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, pos, "x-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, pos, "y+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, pos, "y-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, pos, "z+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, pos, "z-", blockToCheckFor, range, module, updateAdjacentBlocks);
    }

    public static List<String> getPlayersFromModule(World world, BlockPos pos, EnumCustomModules module) {
        ArrayList<String> list = new ArrayList<String>();
        CustomizableSCTE te = (CustomizableSCTE)world.func_175625_s(pos);
        if (te.hasModule(module)) {
            ItemStack item = te.getModule(module);
            for (int i = 1; i <= 10; ++i) {
                if (item.func_77978_p() == null || item.func_77978_p().func_74779_i("Player" + i) == null || item.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                list.add(item.func_77978_p().func_74779_i("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean checkForModule(World world, BlockPos pos, EntityPlayer player, EnumCustomModules module) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof CustomizableSCTE)) {
            return false;
        }
        if (te instanceof TileEntityKeypad) {
            if (module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keypad.name", new Object[0]), ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                return true;
            }
            if (module == EnumCustomModules.BLACKLIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.BLACKLIST).contains(player.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keypad.name", new Object[0]), ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                return true;
            }
        } else if (te instanceof TileEntityKeycardReader) {
            if (module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keycardReader.name", new Object[0]), ClientUtils.localize("messages.securitycraft:module.whitelisted", new Object[0]), TextFormatting.GREEN);
                world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c());
                return true;
            }
            if (module == EnumCustomModules.BLACKLIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.BLACKLIST).contains(player.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keycardReader.name", new Object[0]), ClientUtils.localize("messages.securitycraft:module.blacklisted", new Object[0]), TextFormatting.RED);
                return true;
            }
        } else if (te instanceof TileEntityRetinalScanner ? module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.WHITELIST).contains(player.func_70005_c_().toLowerCase()) : te instanceof TileEntityInventoryScanner && module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.WHITELIST).contains(player.func_70005_c_().toLowerCase())) {
            return true;
        }
        return false;
    }
}

