/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;

public enum ForgeBounds {
    ATTACK_SPEED(0.0f, 4.0f),
    BARGAINS_PER_TRADER(1, 6),
    BLOCK_HARDNESS(-1, 100),
    BLOCK_RESISTANCE(-1, 320),
    CHEMICAL_EXPLOSION_PROBABILITY(0.0f, 0.5f),
    CHEMICAL_EXPLOSION_STRENGTH(0.0f, 8.0f),
    DAMAGE_REDUCTION(0, 30),
    DIMENSION_ID(Integer.MIN_VALUE, Integer.MAX_VALUE),
    DURABILITY(0, 2000),
    ENCHANTABILITY(0, 25),
    EXPERIENCE(0, 256),
    FACTOR(0.0f, 1.0f),
    HARDNESS(0, 10),
    HARVEST_LEVEL(-1, 4),
    HARVEST_XP(0, 7),
    HEIGHT(0, 256),
    KEY_CODE(-100, 223),
    LIGHT_VALUE(0, 15),
    ORE_BLOCKS_IN_DEPOSIT(32, 256),
    ORE_BLOCKS_IN_VEIN(1, 12),
    ORE_DEPOSIT_CHANCE(0.0f, 0.01f),
    ORE_VEINS_IN_CHUNK(1, 32),
    ORE_Y(5, 128),
    RAIL_SIGNAL_DISTANCE(0, 16),
    RESISTANCE(0.0f, 32.0f),
    SMELTING_XP(0, 7),
    STACK_SIZE(1, 64),
    TOUGHNESS(0.0f, 3.0f);

    private final IntBounds intBounds;
    private final FloatBounds floatBounds;

    private ForgeBounds(int min, int max) {
        this.intBounds = new IntBounds(min, max);
        this.floatBounds = new FloatBounds(Float.valueOf(min), Float.valueOf(max));
    }

    private ForgeBounds(float min, float max) {
        this.floatBounds = new FloatBounds(Float.valueOf(min), Float.valueOf(max));
        this.intBounds = new IntBounds((int)min, (int)max);
    }

    public static float invertFactor(float factor) {
        return ForgeBounds.FACTOR.getFloatBounds().max.floatValue() - factor;
    }

    public FloatBounds getFloatBounds() {
        return this.floatBounds;
    }

    public IntBounds getIntBounds() {
        return this.intBounds;
    }
}

