/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public final class ForgeLocating {
    public static final String PATH_DELIMITER = "/";

    protected static ResourceLocation texture(String modId, Folders folder, String name, String ... subFolders) {
        String folderName = "";
        if (folder != null && folder != Folders.textures) {
            folderName = folder.name();
        }
        String subDir = "";
        if (subFolders != null) {
            subDir = String.join((CharSequence)PATH_DELIMITER, subFolders);
        }
        String path = String.join((CharSequence)PATH_DELIMITER, Folders.textures.name(), folderName, subDir, name.toLowerCase(Locale.ROOT) + Extensions.png.getWithDot());
        path = path.replace("//", PATH_DELIMITER);
        return new ResourceLocation(modId, path);
    }

    public static ResourceLocation customTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, null, name, subFolders);
    }

    public static ResourceLocation blockTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.blocks, name, subFolders);
    }

    public static ResourceLocation entityTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.entity, name, subFolders);
    }

    public static ResourceLocation guiTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.gui, name, subFolders);
    }

    public static ResourceLocation itemTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.items, name, subFolders);
    }

    public static enum Extensions {
        png;


        public String getWithDot() {
            return "." + this.name();
        }
    }

    public static enum Folders {
        blocks,
        entity,
        items,
        gui,
        textures;

    }
}

