/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.units.UnitId;
import java.io.File;
import java.nio.file.Path;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

public class ForgeConfig
extends Configuration {
    public static final String EXTENSION = ".cfg";
    public static final String KEY_LIST = "list";

    public ForgeConfig(File file) {
        super(file, true);
        this.load();
    }

    protected Logger getLogger() {
        return ForgeMain.instance.getLogger();
    }

    public static String getDescription(String param, String description, boolean addCR) {
        return param + " " + description + (addCR ? "\n" : "");
    }

    public static String getSyntax(Object ... args) {
        return "Syntax: " + Args.join(args);
    }

    public static boolean getBool(ForgeConfig config, String category, String key, boolean defaultValue, String comment) {
        if (config != null && category != null && key != null) {
            return config.getBool(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static int getInt(ForgeConfig config, String category, String key, int defaultValue, IntBounds bounds, String comment) {
        if (config != null && category != null && key != null) {
            return config.getInt(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.Range.enclose(defaultValue, bounds);
    }

    public static float getFloat(ForgeConfig config, String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        if (config != null && category != null && key != null) {
            return config.getFloat(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.Range.enclose(defaultValue, bounds);
    }

    public static String getStr(ForgeConfig config, String category, String key, String defaultValue, String comment) {
        if (config != null && category != null && key != null) {
            return config.getStr(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static ColorARGB getColorARGB(ForgeConfig config, String category, String key, ColorARGB defaultValue, String comment) {
        if (config != null && category != null && key != null) {
            return config.getColorARGB(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static UnitId getUnitId(ForgeConfig config, String category, String key, UnitId defaultValue, String comment) {
        if (config != null && category != null && key != null) {
            return config.getUnitId(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static String[] getStrArray(ForgeConfig config, String category, String key, String[] defaultValues, String comment) {
        if (config != null && category != null && key != null) {
            return config.getStrArray(category, key, defaultValues, comment);
        }
        return defaultValues;
    }

    public boolean getBool(String category, String key, boolean defaultValue, String comment) {
        try {
            return this.getBoolean(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public int getInt(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        try {
            return this.getInt(key, category, defaultValue, (int)bounds.min, bounds.max, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose(defaultValue, bounds);
        }
    }

    public float getFloat(String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        try {
            return this.getFloat(key, category, defaultValue, bounds.min.floatValue(), bounds.max.floatValue(), comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose(defaultValue, bounds);
        }
    }

    public String getStr(String category, String key, String defaultValue, String comment) {
        try {
            return this.getString(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public ColorARGB getColorARGB(String category, String key, ColorARGB defaultValue, String comment) {
        try {
            String hexARGB = this.getString(key, category, defaultValue.getHexARGB(), comment);
            return ColorARGB.from(hexARGB);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public UnitId getUnitId(String category, String key, UnitId defaultValue, String comment) {
        try {
            String stringId = this.getString(key, category, defaultValue.toString(), comment);
            return UnitId.from(stringId);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public String[] getStrArray(String category, String key, String[] defaultValues, String comment) {
        try {
            return this.getStringList(key, category, defaultValues, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValues;
        }
    }

    public Path getConfigDir() {
        return this.getConfigFile().getParentFile().toPath();
    }
}

