/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeRecipe;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.units.ForgeStack;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.List;

public class CraftingRecipe
extends ForgeRecipe {
    private final String pattern;
    private final UnitId outputId;
    private final int amount;
    private final List<UnitId> components = new ArrayList<UnitId>();
    private final ForgeConfig config;

    protected static CraftingRecipe Create(ForgeRecipe.Type type, ForgeConfig config, String pattern, String output, int amount, String ... components) {
        String category = IHaveConfig.getClassCategory(CraftingRecipe.class, type.name());
        return new CraftingRecipe(config, category, pattern, output, amount, components);
    }

    protected static CraftingRecipe Create(String headCategory, ForgeRecipe.Type type, ForgeConfig config, String pattern, String output, int amount, String ... components) {
        String category = IHaveConfig.expandClassCategory(CraftingRecipe.class, headCategory, type.name());
        return new CraftingRecipe(config, category, pattern, output, amount, components);
    }

    public static CraftingRecipe CreateMain(ForgeConfig config, String pattern, String output, int amount, String ... components) {
        return CraftingRecipe.Create(ForgeRecipe.Type.main, config, pattern, output, amount, components);
    }

    public static CraftingRecipe CreateMain(String headCategory, ForgeConfig config, String pattern, String output, int amount, String ... components) {
        return CraftingRecipe.Create(headCategory, ForgeRecipe.Type.main, config, pattern, output, amount, components);
    }

    public static CraftingRecipe CreateReserve(ForgeConfig config, String pattern, String output, int amount, String ... components) {
        return CraftingRecipe.Create(ForgeRecipe.Type.reserve, config, pattern, output, amount, components);
    }

    public static CraftingRecipe CreateReserve(String headCategory, ForgeConfig config, String pattern, String output, int amount, String ... components) {
        return CraftingRecipe.Create(headCategory, ForgeRecipe.Type.reserve, config, pattern, output, amount, components);
    }

    public CraftingRecipe(String pattern, String output, int amount, String ... components) {
        this(null, null, pattern, output, amount, components);
    }

    protected CraftingRecipe(ForgeConfig config, String category, String pattern, String output, int amount, String ... components) {
        this.config = config;
        this.pattern = ForgeConfig.getStr(config, category, "pattern", pattern, "Shaped recipe pattern in format <nn nn> or <nnn nnn nnn>.\nWhere 'n' - number of recipe component (from 1 to 9).\nZero value (0) is for empty slot.\nIf pattern is empty, then recipe will be treated as shapeless.");
        this.outputId = ForgeConfig.getUnitId(config, category, "output", UnitId.from(output), "Output unit id.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nAlso you may use just ore dictionary name as full id.\n");
        this.amount = ForgeConfig.getInt(config, category, "amount", amount, ForgeBounds.STACK_SIZE.getIntBounds(), "Amount of output units.");
        String[] componentsArray = ForgeConfig.getStrArray(config, category, "components", components, "Recipe components list.\nComponents should be represented by its ids.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nAlso you may use just ore dictionary name as full id.\n");
        if (componentsArray != null) {
            for (int i = 0; i < componentsArray.length; ++i) {
                this.components.add(UnitId.from(componentsArray[i]));
            }
        }
    }

    public ForgeStack getOutputStack() {
        return this.outputId.getItemState().toStack(this.amount);
    }

    public Object[] getParams() {
        ArrayList<Object> objList = new ArrayList<Object>();
        if (this.pattern != null && this.components != null) {
            String purePattern = this.getPattern(true);
            int gridSize = (int)Math.sqrt(purePattern.length());
            assert (gridSize * gridSize == purePattern.length());
            for (int i = 0; i < gridSize; ++i) {
                int beginIndex = i * gridSize;
                int endIndex = beginIndex + gridSize;
                objList.add(purePattern.substring(beginIndex, endIndex).replace("0", " "));
            }
        }
        if (this.components != null) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.isShapeless()) {
                    objList.add(Character.valueOf(String.valueOf(i + 1).charAt(0)));
                }
                objList.add(this.components.get(i).getItemState().toItemStack(1));
            }
        }
        return objList.toArray();
    }

    public String getPattern(boolean noSpaces) {
        return noSpaces && this.pattern != null ? this.pattern.replace(" ", "") : this.pattern;
    }

    @Override
    public boolean isValid() {
        this.statusDescription = "";
        if (this.outputId.isEmpty()) {
            this.statusDescription = "EMPTY output";
            return false;
        }
        if (this.components.isEmpty()) {
            this.statusDescription = "EMPTY component list";
            return false;
        }
        int LENGTH_SHORT = 4;
        int LENGHT_FULL = 9;
        if (this.pattern != null) {
            int length = this.getPattern(true).length();
            if (length != 4 && length != 9) {
                this.statusDescription = String.format("pattern length is %d, but should be %d or %d", length, 4, 9);
                return false;
            }
            for (char ch : this.getPattern(true).toCharArray()) {
                String s = String.valueOf(ch);
                int i = 0;
                try {
                    i = Integer.parseInt(s);
                }
                catch (Exception e) {
                    this.statusDescription = String.format("pattern has unacceptable char '%s'", s);
                    return false;
                }
                if (i == 0 || --i >= 0 && i < this.components.size()) continue;
                this.statusDescription = String.format("pattern '%d' value refers to not existing component", i);
                return false;
            }
        }
        for (UnitId id : this.components) {
            if (!id.isEmpty()) continue;
            this.statusDescription = "component is EMPTY";
            return false;
        }
        if (this.isShapeless()) {
            ArrayList<UnitId> list = new ArrayList<UnitId>();
            Object object = this.components.iterator();
            while (object.hasNext()) {
                UnitId id = (UnitId)object.next();
                if (list.contains(id)) {
                    this.statusDescription = "DUPLICATE components";
                    return false;
                }
                list.add(id);
            }
        }
        return true;
    }

    public String toString() {
        return CraftingRecipe.class.getSimpleName() + Args.group(Args.get("status", CraftingRecipe.getStatus(this)), Args.get("pattern", this.pattern), Args.get("output", this.getOutputStack().exists() ? this.getOutputStack() : this.outputId), Args.get("components", this.components));
    }

    @Override
    public boolean isReadyToRegister() {
        if (!this.getOutputStack().exists()) {
            this.statusDescription = "output stack does not exist!";
            return false;
        }
        for (UnitId id : this.components) {
            if (id.getItemState().exists()) continue;
            this.statusDescription = "unknown component: " + id;
            return false;
        }
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    public boolean isShapeless() {
        return CommonString.isNullOrEmpty(this.pattern);
    }
}

