/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.ores;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.Dimensions;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.EnumSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OreGeneration {
    public static boolean generate(World inWorld, BlockPos atPos, IBlockState oreBlock, int oreBlocksAmount, UnitId replaceableBlockId) {
        if (!replaceableBlockId.getBlockState().exists()) {
            return false;
        }
        float f = CommonMath.Random.getFloat() * (float)Math.PI;
        double d0 = (float)(atPos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)oreBlocksAmount / 8.0f;
        double d1 = (float)(atPos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)oreBlocksAmount / 8.0f;
        double d2 = (float)(atPos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)oreBlocksAmount / 8.0f;
        double d3 = (float)(atPos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)oreBlocksAmount / 8.0f;
        double d4 = atPos.func_177956_o() + CommonMath.Random.between(-2, 2);
        double d5 = atPos.func_177956_o() + CommonMath.Random.between(-2, 2);
        for (int i = 0; i < oreBlocksAmount; ++i) {
            float f1 = (float)i / (float)oreBlocksAmount;
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = CommonMath.Random.getDouble() * (double)oreBlocksAmount / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        BlockPos blockPos = new BlockPos(l1, i2, j2);
                        IBlockState blockState = inWorld.func_180495_p(blockPos);
                        if (!replaceableBlockId.getBlockState().matches(blockState)) continue;
                        inWorld.func_180501_a(blockPos, oreBlock, 2);
                    }
                }
            }
        }
        return true;
    }

    public static class Disabler {
        private EnumSet<OreGenEvent.GenerateMinable.EventType> disabledOres = EnumSet.noneOf(OreGenEvent.GenerateMinable.EventType.class);

        public Disabler() {
            MinecraftForge.ORE_GEN_BUS.register((Object)this);
        }

        public boolean addOre(OreGenEvent.GenerateMinable.EventType ore) {
            return this.disabledOres.add(ore);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void handleOreGenEvent(OreGenEvent event) {
            if (event instanceof OreGenEvent.GenerateMinable && this.disabledOres.contains(((OreGenEvent.GenerateMinable)event).getType())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    public static class Data {
        public static final float DEFAULT_DISPERSION = 0.5f;
        private final int minY;
        private final int maxY;
        private final int blocksInVein;
        private final int veinsInChunk;
        private final float dispersion;
        private final int blocksInDeposit;
        private final float depositChance;
        private final int dimensionId;
        private final UnitId replaceableBlockId;

        public Data(UnitConfig config, String category, ForgeMaterial material) {
            this(config, category, ForgeBounds.ORE_Y.getIntBounds().min, ForgeBounds.ORE_Y.getIntBounds().approxUp(material.getFrequency()), ForgeBounds.ORE_BLOCKS_IN_VEIN.getIntBounds().approxUp(material.getFrequency()), ForgeBounds.ORE_VEINS_IN_CHUNK.getIntBounds().approxUp(material.getFrequency()), 0.5f, ForgeBounds.ORE_BLOCKS_IN_DEPOSIT.getIntBounds().approxUp(material.getFrequency()), ForgeBounds.ORE_DEPOSIT_CHANCE.getFloatBounds().approxUp(material.getFrequency()).floatValue());
        }

        public Data(UnitConfig config, String category, int minY, int maxY, int blocksInVein, int veinsInChunk, float dispersion, int blocksInDeposit, float depositChance) {
            this.minY = ForgeConfig.getInt(config, category, "minY", minY, ForgeBounds.HEIGHT.getIntBounds(), "Minimal height which ore will be generated at.");
            this.maxY = ForgeConfig.getInt(config, category, "maxY", maxY, ForgeBounds.HEIGHT.getIntBounds(), "Maximal height which ore will be generated at.");
            this.blocksInVein = ForgeConfig.getInt(config, category, "blocksInVein", blocksInVein, ForgeBounds.ORE_BLOCKS_IN_VEIN.getIntBounds(), "Number of ore blocks in one vein");
            this.veinsInChunk = ForgeConfig.getInt(config, category, "veinsInChunk", veinsInChunk, ForgeBounds.ORE_VEINS_IN_CHUNK.getIntBounds(), "Number of ore veins in one chunk");
            this.dispersion = ForgeConfig.getFloat(config, category, "dispersion", dispersion, ForgeBounds.FACTOR.getFloatBounds(), "Amount dispersion where 1 means 100%");
            this.blocksInDeposit = ForgeConfig.getInt(config, category, "blocksInDeposit", blocksInDeposit, ForgeBounds.ORE_BLOCKS_IN_DEPOSIT.getIntBounds(), "Number of blocks in one ore deposit");
            this.depositChance = ForgeConfig.getFloat(config, category, "depositChance", depositChance, ForgeBounds.ORE_DEPOSIT_CHANCE.getFloatBounds(), "Probability of large ore deposit appearing");
            this.dimensionId = ForgeConfig.getInt(config, category, "dimensionId", Dimensions.overworld.ID, ForgeBounds.DIMENSION_ID.getIntBounds(), "Dimension which the ore will be generated at.");
            this.replaceableBlockId = ForgeConfig.getUnitId(config, category, "replaceableBlockId", Dimensions.overworld.replaceableBlockId, "Id of a block which should be replaced by the generated ore.");
        }

        protected int getDispersed(int value) {
            float disp = CommonMath.Random.between(0.0f, (float)value * this.dispersion);
            if (CommonMath.Random.getBoolean()) {
                disp = -disp;
            }
            return value + CommonMath.getRounded(disp);
        }

        protected int generateYcoord() {
            return CommonMath.Random.between(this.minY, this.maxY);
        }

        protected int generateBlocksInVeinAmount() {
            return ForgeBounds.ORE_BLOCKS_IN_VEIN.getIntBounds().enclose(this.getDispersed(this.blocksInVein));
        }

        protected int generateVeinsInChunkAmount() {
            return ForgeBounds.ORE_VEINS_IN_CHUNK.getIntBounds().enclose(this.getDispersed(this.veinsInChunk));
        }

        protected int generateBlocksInDepositAmount() {
            return ForgeBounds.ORE_BLOCKS_IN_DEPOSIT.getIntBounds().enclose(this.getDispersed(this.blocksInDeposit));
        }

        protected boolean canGenerate(World inWorld) {
            return inWorld.field_73011_w.getDimension() == this.dimensionId && this.replaceableBlockId.getBlockState().exists();
        }

        public void generate(World inWorld, ChunkPos atPos, IBlockState oreBlock) {
            if (this.canGenerate(inWorld)) {
                if (this.isDepositShouldBeGenerated()) {
                    this.generateDeposit(inWorld, atPos, oreBlock);
                } else {
                    this.generateVeins(inWorld, atPos, oreBlock);
                }
            }
        }

        protected void generateVeins(World inWorld, ChunkPos atPos, IBlockState oreBlock) {
            int veinsAmount = this.generateVeinsInChunkAmount();
            int blocksInVein = this.generateBlocksInVeinAmount();
            for (int i = 0; i < veinsAmount; ++i) {
                BlockPos veinPos = new BlockPos(CommonMath.Random.between(atPos.func_180334_c(), atPos.func_180332_e()), this.generateYcoord(), CommonMath.Random.between(atPos.func_180333_d(), atPos.func_180330_f()));
                OreGeneration.generate(inWorld, veinPos, oreBlock, blocksInVein, this.replaceableBlockId);
            }
        }

        protected void generateDeposit(World inWorld, ChunkPos atPos, IBlockState oreBlock) {
            int blocksInDeposit = this.generateBlocksInDepositAmount();
            int halfChunkSize = 8;
            BlockPos depositPos = new BlockPos(atPos.func_180334_c() + halfChunkSize, Math.max(halfChunkSize, this.generateYcoord()), atPos.func_180333_d() + halfChunkSize);
            OreGeneration.generate(inWorld, depositPos, oreBlock, blocksInDeposit, this.replaceableBlockId);
            ForgeMain.instance.getLogger().info("{} deposit with {} blocks generated at {} (ChunkPos{})", new Object[]{oreBlock, blocksInDeposit, depositPos, atPos});
        }

        public String toString() {
            return Data.class.getSimpleName() + Args.group(Args.get("minY", this.minY), Args.get("maxY", this.maxY), Args.get("blocksInVein", this.blocksInVein), Args.get("veinsInChunk", this.veinsInChunk), Args.get("dispersion", Float.valueOf(this.dispersion)), Args.get("dimensionId", this.dimensionId), Args.get("replaceableBlockId", this.replaceableBlockId));
        }

        protected boolean isDepositShouldBeGenerated() {
            return CommonMath.Random.result(this.depositChance);
        }
    }
}

