/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tools;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.materials.IMaterialBased;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ForgeTool
extends ForgeItem
implements IMaterialBased {
    private String modifierName = "Tool modifier";
    private final ForgeMaterial material;
    private final FloatBounds damageBounds;
    private final FloatBounds speedBounds;
    private final Set<Block> blocksEffectiveOn = Sets.newConcurrentHashSet();
    private final Set<Material> materialsEffectiveOn = Sets.newConcurrentHashSet();

    public ForgeTool(ForgeMod mod, UnitConfig config, ForgeMaterial material, FloatBounds damageBounds, FloatBounds speedBounds, Set<Block> blocksEffectiveOn, Set<Material> materialsEffectiveOn) {
        super(mod, config, material.getName(), CreativeTabs.field_78040_i);
        this.material = material;
        float minDamage = config.getFloat(this.getConfigCategory(), "minDamage", damageBounds.min.floatValue(), new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)), "Defines minimum possible damage for this tool");
        float maxDamage = config.getFloat(this.getConfigCategory(), "maxDamage", damageBounds.max.floatValue(), new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)), "Defines maximum possible damage for this tool");
        this.damageBounds = new FloatBounds(Float.valueOf(minDamage), Float.valueOf(maxDamage));
        float minSpeed = config.getFloat(this.getConfigCategory(), "minSpeed", speedBounds.min.floatValue(), ForgeBounds.ATTACK_SPEED.getFloatBounds(), "Defines minimum possible speed for this tool");
        float maxSpeed = config.getFloat(this.getConfigCategory(), "maxSpeed", speedBounds.max.floatValue(), ForgeBounds.ATTACK_SPEED.getFloatBounds(), "Defines maximum possible speed for this tool");
        this.speedBounds = new FloatBounds(Float.valueOf(minSpeed), Float.valueOf(maxSpeed));
        this.blocksEffectiveOn.addAll(blocksEffectiveOn);
        this.materialsEffectiveOn.addAll(materialsEffectiveOn);
        this.setHarvestLevel(this.getToolClass(), ForgeTool.calculateHarvestLevel(material.getStrength()));
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public static float calculateAttackDamage(float materialStrength, float materialHeaviness, FloatBounds damageBounds) {
        return damageBounds.approxUp(materialStrength).floatValue();
    }

    public static float calculateAttackSpeed(float materialHeaviness, FloatBounds speedBounds) {
        return speedBounds.approxDown(materialHeaviness).floatValue();
    }

    public static float calculateEfficiency(float materialStrength) {
        return ForgeBounds.HARDNESS.getFloatBounds().approxUp(materialStrength).floatValue();
    }

    public static int calculateHarvestLevel(float materialStrength) {
        float harvestLevel = ForgeBounds.HARVEST_LEVEL.getFloatBounds().approxUp(materialStrength).floatValue();
        return (int)Math.ceil(harvestLevel);
    }

    public static String getToolClass(Class<?> classType) {
        return classType.getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    public String getToolClass() {
        return ForgeTool.getToolClass(this.getClass());
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, this.getModifierName(), (double)this.getAttackDamage(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, this.getModifierName(), (double)(-ForgeBounds.ATTACK_SPEED.getFloatBounds().max.floatValue() + this.getAttackSpeed()), 0));
        }
        return multimap;
    }

    public int func_77619_b() {
        return ForgeMaterial.calculateEnchantability(this.getMaterial().getMagicability());
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.getMaterial().getId().getItemState().getItem() == repair.func_77973_b();
    }

    public boolean isEffectiveOn(IBlockState state) {
        return this.getBlocksEffectiveOn().contains(state.func_177230_c()) || this.getMaterialsEffectiveOn().contains(state.func_185904_a());
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.isEffectiveOn(state) ? this.getEfficiency() : super.func_150893_a(stack, state);
    }

    public float getAttackDamage() {
        return ForgeTool.calculateAttackDamage(this.getMaterial().getStrength(), this.getMaterial().getHeaviness(), this.getDamageBounds());
    }

    public float getAttackSpeed() {
        return ForgeTool.calculateAttackSpeed(this.getMaterial().getHeaviness(), this.getSpeedBounds());
    }

    public float getEfficiency() {
        return ForgeTool.calculateEfficiency(this.getMaterial().getStrength());
    }

    public int getHarvestLevel() {
        return ForgeTool.calculateHarvestLevel(this.getMaterial().getStrength());
    }

    protected String getModifierName() {
        return this.modifierName;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            int damage = this.isEffectiveOn(state) ? 1 : 2;
            stack.func_77972_a(damage, entityLiving);
        }
        return true;
    }

    @Override
    public ForgeMaterial getMaterial() {
        return this.material;
    }

    protected Set<Block> getBlocksEffectiveOn() {
        return this.blocksEffectiveOn;
    }

    protected Set<Material> getMaterialsEffectiveOn() {
        return this.materialsEffectiveOn;
    }

    protected FloatBounds getDamageBounds() {
        return this.damageBounds;
    }

    protected FloatBounds getSpeedBounds() {
        return this.speedBounds;
    }
}

