/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.units.BlockState;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adfinders.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Target {
    public static final Target EMPTY = new Target(BlockState.EMPTY, ColorARGB.DEFAULT, "");
    private final BlockState blockState;
    private final ColorARGB color;
    private final String name;

    protected Target(BlockState state, ColorARGB color, String name) {
        this.blockState = state;
        this.color = color;
        this.name = name;
    }

    public static Target from(BlockState state, ColorARGB color, String name) {
        return new Target(state, color, name);
    }

    public static List<Target> from(String definition) {
        ArrayList<Target> resultList = new ArrayList<Target>();
        String[] args = Args.split((String)definition);
        try {
            UnitId id = UnitId.from((String)args[0]);
            ColorARGB color = ColorARGB.from((String)args[1]);
            String name = args.length > 2 ? args[2] : id.getRegName();
            List states = id.getAllBlockStates();
            for (BlockState state : states) {
                Target target = Target.from(state, color, name);
                if (resultList.contains(target)) continue;
                resultList.add(target);
            }
        }
        catch (Exception e) {
            Main.instance.getLogger().error("Wrong target info in string: '{}'", new Object[]{definition});
        }
        return resultList;
    }

    public static String definition(UnitId blockId, ColorARGB color, String name) {
        return Args.join((Object[])new Object[]{blockId.toString(), color.getHexARGB(), name});
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        return this.getBlockState().exists();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Target) {
            Target target = (Target)obj;
            return target.getBlockState().equals((Object)this.getBlockState()) && target.getColor().equals((Object)this.getColor()) && target.getName().equals(this.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getBlockState(), this.getColor(), this.getName());
    }

    public String toString() {
        return Target.class.getSimpleName() + Args.group((Object[])new Object[]{this.getBlockState(), this.getColor(), this.getName()});
    }
}

