/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.forge.versions.ForgeJoiner;
import com.endertech.minecraft.forge.versions.GameVersions;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.Ores;
import com.endertech.minecraft.mods.adfinders.init.Finders;

public class Targets {
    public static void initSubstratum() {
        String modId = "substratum";
        String ore = "ore";
        String oreDust = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"ore", "dust"}).oreDictFormatFor(GameVersions.V10).toString();
        Finders.METALS.definitions.forMod(modId).addOres("ore", 0, Ores.COPPER, Ores.TIN, Ores.NICKEL, Ores.ZINC, Ores.SILVER, Ores.LEAD).addOre(ore, 6, -3746586, Ores.PLATINUM.getName()).addOre(ore, 7, -5857609, Ores.ALUMINUM.getName()).addOre(ore, 8, -11579547, Ores.CHROME.getName());
        Finders.MINERALS.definitions.forMod(modId).addOre(oreDust, Ores.SULFUR).addOre(oreDust, 1, -2176305, Ores.NITER.getName());
    }

    public static void initMysticalAgriculture() {
        String modId = "mysticalagriculture";
        String[] prefixes = new String[]{"", "nether", "end"};
        Finders.METALS.definitions.forMod(modId).withPrefixes(prefixes).withOreSuffix().addOre("inferium", -8809216);
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefixes).withOreSuffix().addOre("prosperity", -3343622);
    }

    public static void initLightningCraft() {
        String modId = "lightningcraft";
        String materialName = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"ore", "block"}).oreDictFormatFor(GameVersions.V10).setFor(GameVersions.V7, new String[]{"tile.underworldOre"}).toString();
        Finders.METALS.definitions.forMod(modId).addOres(materialName, 0, Ores.IRON, Ores.GOLD);
        Finders.GEMS.definitions.forMod(modId).addOres(materialName, 2, Ores.DIAMOND, Ores.EMERALD);
    }

    public static void initFuturePack() {
        String modId = "fp";
        String erze = "erze";
        Finders.GEMS.definitions.forMod(modId).addOres(erze, 5, Ores.QUARTZ);
        Finders.METALS.definitions.forMod(modId).addOres(erze, 0, Ores.TIN, Ores.ZINC, Ores.COPPER).addOre(erze, 4, -7766194, "magnetite").addOres(erze, 6, Ores.COPPER);
        Finders.MINERALS.definitions.forMod(modId).addOre(erze, 3, -6608128, Ores.BAUXITE.getName()).addOres(erze, 7, Ores.COAL);
    }

    public static void initEbonArts() {
        String modId = "ea";
        String orePrefix = new ForgeJoiner(new String[]{"ore/"}).setFor(GameVersions.V7, new String[]{"ores/"}).toString();
        String oreSuffix = "_ore";
        String ebon = "ebon";
        String[] oreSuffixes = new String[]{oreSuffix, oreSuffix + "_nether", oreSuffix + "_end"};
        Finders.GEMS.definitions.forMod(modId).withNoDelimiters().withPrefixes(orePrefix).withSuffixes(oreSuffix).addOre("arcanite", -15880549).addOre("katcheen", -65536).addOre("velious", -14084504).withSuffixes(oreSuffixes).addOre("necrocite", -12062720).addOre("soularite", -674045).addOre("ebonheart", -9704983).addOre(ebon, 0, Ores.LAPIS.getARGB(), ebon);
        Finders.METALS.definitions.forMod(modId).withNoDelimiters().withPrefixes(orePrefix).withSuffixes(oreSuffixes).addOre(ebon, 0, Ores.GOLD.getARGB(), ebon);
        Finders.MINERALS.definitions.forMod(modId).withNoDelimiters().withPrefixes(orePrefix).withSuffixes(oreSuffix).addOre("draconium", -348422).withSuffixes(oreSuffixes).addOre(ebon, 0, Ores.REDSTONE.getARGB(), ebon);
    }

    public static void initForestry() {
        String modId = new ForgeJoiner(new String[]{"forestry"}).capitalizeWordsFor(GameVersions.V7).toString();
        String resources = "resources";
        Finders.METALS.definitions.forMod(modId).addOre(resources, 0, -14251319, "apatite").addOre(resources, 1, -3891413, Ores.COPPER.getName()).addOre(resources, 2, -2171950, Ores.TIN.getName());
    }

    public static void initActuallyAdditions() {
        String modId = new ForgeJoiner(new String[]{"actually", "additions"}).capitalizeWordsFor(GameVersions.V7).toString();
        String blockMisc = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"block", "misc"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOres(blockMisc, 3, Ores.DARK_QUARTZ);
    }

    public static void initAbyssalCraft() {
        String modId = "abyssalcraft";
        String prefix = "aby";
        String coralium = "coralium";
        String abyssalnite = "abyssalnite";
        Finders.GEMS.definitions.forMod(modId).withNoDelimiters().addOre(coralium + "stone", -10706518, coralium).withOreSuffix().addOre(coralium, -15832460, coralium).withPrefixes(prefix).addOre("dia", Ores.DIAMOND).addOre("cor", -15832460, coralium).addOre("pcor", -10706518, coralium);
        Finders.METALS.definitions.forMod(modId).withNoDelimiters().withOreSuffix().addOre("dread", -11730397, abyssalnite).withPrefixes(prefix).addOre("lcor", -15883118, coralium).addOre("", -11199579, abyssalnite).addOre("dread", -11199579, abyssalnite).addOre("iro", Ores.IRON).addOre("gol", Ores.GOLD).addOre("tin", Ores.TIN).addOre("cop", Ores.COPPER);
        Finders.MINERALS.definitions.forMod(modId).withNoDelimiters().withOreSuffix().addOre("nitre", Ores.NITER).withPrefixes(prefix).addOre("nit", Ores.NITER);
    }

    public static void initVanilla() {
        String modId = "minecraft";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Ores.DIAMOND).addOre(Ores.EMERALD).addOre(Ores.LAPIS).addOre(Ores.QUARTZ);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.IRON).addOre(Ores.GOLD);
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.COAL).addOre(Ores.REDSTONE).addOre("lit_redstone", Ores.REDSTONE);
    }

    public static void initAdOver() {
        String modId = "adover";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Ores.DIAMOND).addOre(Ores.EMERALD).addOre(Ores.RUBY).addOre(Ores.SAPPHIRE).addOre(Ores.TOPAZ);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.IRON).addOre(Ores.SILVER).addOre(Ores.GOLD).addOre(Ores.OSMIUM).addOre("titanium", Ores.TITANIUM).addOre("adamantium", Ores.ADAMANTIUM).addOre(Ores.URANIUM);
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.COAL).addOre(Ores.REDSTONE).addOre(Ores.SULFUR);
    }

    public static void initBiomesOplenty() {
        String modId = new ForgeJoiner(new String[]{"biomes", "o", "plenty"}).capitalizeWordsFor(GameVersions.V7).toString();
        String biomeBlock = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"biome", "block"}).oreDictFormatFor(GameVersions.V7).toString();
        String gemOre = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"gem", "ore"}).oreDictFormatFor(GameVersions.V7).toString();
        boolean isV7 = GameVersions.V7.isRunning();
        int metaStep = isV7 ? 2 : 1;
        Finders.GEMS.definitions.forMod(modId).addOres(gemOre, 0, metaStep, Ores.AMETHYST, Ores.RUBY, Ores.PERIDOT, Ores.TOPAZ, Ores.TANZANITE, Ores.MALACHITE).addOre(gemOre, 6 * metaStep, -15040557, Ores.SAPPHIRE.getName()).addOre(gemOre, 7 * metaStep, Ores.AMBER);
        Finders.MINERALS.definitions.forMod(modId).addOre(biomeBlock, -1, "biome_essense");
    }

    public static void initUndergroundBiomes() {
        String modId = new ForgeJoiner(new String[]{"underground", "biomes"}).capitalizeWordsFor(GameVersions.V7).toString();
        String igneous = "igneous";
        String metamorphic = "metamorphic";
        String sedimentary = "sedimentary";
        String ore = new ForgeJoiner(new String[]{"stone"}).setFor(GameVersions.V7, new String[]{"ore"}).toString();
        String[] prefixes = Definitions.Prefixes.create().add(igneous, ore).add(metamorphic, ore).add(sedimentary, ore).toArray();
        String delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7).toString();
        String suffix = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{""}).toString();
        boolean capitalized = GameVersions.getCurrent() == GameVersions.V7;
        int meta = Short.MAX_VALUE;
        Finders.GEMS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOre(capitalized, meta, Ores.DIAMOND).addOre(capitalized, meta, Ores.EMERALD).addOre(capitalized, meta, Ores.LAPIS);
        Finders.METALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOre(capitalized, meta, Ores.GOLD).addOre(capitalized, meta, Ores.IRON);
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOre(capitalized, meta, Ores.COAL).addOre(capitalized, meta, Ores.REDSTONE);
    }

    public static void initFunOres() {
        String modId = new ForgeJoiner(new String[]{"fun", "ores"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"metal", "ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, Ores.COPPER).addOre(ore, 1, -5790578, Ores.TIN.getName()).addOres(ore, 2, Ores.SILVER, Ores.LEAD).addOre(ore, 4, -4491143, Ores.NICKEL.getName()).addOres(ore, 5, Ores.PLATINUM, Ores.ALUMINUM, Ores.ZINC, Ores.TITANIUM, Ores.OSMIUM);
    }

    public static void initThermalFoundation() {
        String modId = new ForgeJoiner(new String[]{"thermal", "foundation"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.METALS.definitions.forMod(modId).addOre(ore, -1155059, Ores.COPPER.getName()).addOre(ore, 1, -7097131, Ores.TIN.getName()).addOre(ore, 2, -2231562, Ores.SILVER.getName()).addOre(ore, 3, -7758115, Ores.LEAD.getName());
        if (GameVersions.V7.isRunning()) {
            Finders.METALS.definitions.addOre(ore, 4, -5002367, "ferrous").addOre(ore, 5, -16744223, "shiny").addOres(ore, 6, Ores.MYTHRIL);
        } else {
            Finders.METALS.definitions.addOres(ore, 4, Ores.ALUMINUM, Ores.NICKEL, Ores.PLATINUM, Ores.IRIDIUM, Ores.MYTHRIL);
        }
    }

    public static void initDraconicEvolution() {
        String modId = new ForgeJoiner(new String[]{"draconic", "evolution"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        int color = -10536575;
        Finders.METALS.definitions.forMod(modId).withNoDelimiters().withSuffixes(ore).addOres("draconium", 0, color, color, color);
    }

    public static void initImmersiveEngineering() {
        String modId = new ForgeJoiner(new String[]{"immersive", "engineering"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = "ore";
        Finders.METALS.definitions.forMod(modId).addOre(ore, -11371417, Ores.COPPER.getName()).addOres(ore, 1, Ores.BAUXITE, Ores.LEAD, Ores.SILVER, Ores.NICKEL).addOre(ore, 5, -11243448, Ores.URANIUM.getName());
    }

    public static void initRailcraft() {
        String modId = new ForgeJoiner(new String[]{"railcraft"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = "ore";
        Finders.GEMS.definitions.forMod(modId).addOres(ore, 2, Ores.DIAMOND, Ores.EMERALD, Ores.LAPIS);
        if (GameVersions.V7.isRunning()) {
            Finders.GEMS.definitions.addOre(ore, 5, -2659815, "firestone");
            Finders.METALS.definitions.forMod(modId).addOres(ore, 7, Ores.IRON, Ores.GOLD).addOre(ore, 9, -8139376, Ores.COPPER.getName()).addOre(ore, 10, -723724, Ores.TIN.getName()).addOre(ore, 11, -8816470, Ores.LEAD.getName());
        } else {
            Finders.GEMS.definitions.addOre("ore_magic", -2659815, "firestone");
            Finders.METALS.definitions.forMod(modId).addOres(ore, 5, Ores.IRON, Ores.GOLD).addOre(ore, 7, -8139376, Ores.COPPER.getName()).addOre(ore, 8, -723724, Ores.TIN.getName()).addOre(ore, 9, -8816470, Ores.LEAD.getName()).addOre(ore, 10, -2699066, Ores.SILVER.getName()).addOre(ore, 11, -8139376, Ores.COPPER.getName()).addOre(ore, 12, -723724, Ores.TIN.getName()).addOre(ore, 13, -8816470, Ores.LEAD.getName()).addOre(ore, 14, -2699066, Ores.SILVER.getName());
        }
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, Ores.SULFUR).addOre(ore, 1, -2171170, "saltpeter");
    }

    public static void initWaterPower() {
        String modId = new ForgeJoiner(new String[]{"water", "power"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"cptBlockOre"}).toString();
        Finders.METALS.definitions.forMod(modId).addOre(ore, -5986157, "monazite").addOre(ore, 1, -7760738, "vanadium").addOre(ore, 2, -11969947, "manganeze").addOre(ore, 3, -14145495, "magnet").addOre(ore, 4, -6704456, Ores.ZINC.getName());
    }

    public static void initQuark() {
        Finders.GEMS.definitions.forMod("quark").withOreSuffix().addOre("biotite", -15132391);
    }

    public static void initTinkersConstruct() {
        String modId = new ForgeJoiner(new String[]{"t", "construct"}).capitalizeWordsFor(GameVersions.V7).toString();
        if (GameVersions.V7.isRunning()) {
            String gravelOre = "GravelOre";
            String searedBrick = "SearedBrick";
            Finders.METALS.definitions.forMod(modId).addOres(gravelOre, 0, Ores.IRON, Ores.GOLD, Ores.COPPER).addOre(gravelOre, 3, -8634854, Ores.TIN.getName()).addOre(gravelOre, 4, -263173, Ores.ALUMINUM.getName()).addOres(gravelOre, 5, Ores.COBALT).addOres(searedBrick, 1, Ores.COBALT).addOre(searedBrick, 2, -9477861, "ardite").addOres(searedBrick, 3, Ores.COPPER).addOre(searedBrick, 4, -8634854, Ores.TIN.getName()).addOre(searedBrick, 5, -263173, Ores.ALUMINUM.getName());
        } else {
            String ore = "ore";
            Finders.METALS.definitions.forMod(modId).addOre("ore", Ores.COBALT).addOre(ore, 1, -9477861, "ardite");
        }
    }

    public static void initTechReborn() {
        String modId = "techreborn";
        String ore = modId + ".ore";
        String ore2 = ore + "2";
        Finders.GEMS.definitions.forMod(modId).addOres(ore, 2, Ores.RUBY).addOre(ore, 3, -16112464, Ores.SAPPHIRE.getName()).addOre(ore, 10, -16145351, Ores.PERIDOT.getName());
        Finders.METALS.definitions.forMod(modId).addOre(ore, 1, -14669276, Ores.IRIDIUM.getName()).addOres(ore, 8, Ores.TUNGSTEN).addOre(ore, 9, -859061, "sheldonite").addOre(ore, 12, -14478280, Ores.LEAD.getName()).addOres(ore, 13, Ores.SILVER).addOre(ore2, -9795460, Ores.COPPER.getName()).addOres(ore2, 1, Ores.TIN, Ores.GARNIERITE);
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, -14807246, "galena").addOres(ore, 4, Ores.BAUXITE).addOre(ore, 5, -1203168, "pyrite").addOre(ore, 6, -4718592, "cinnabar").addOre(ore, 7, -689603, "sphalerite").addOre(ore, 11, -15916624, "sodalite");
    }

    public static void initAdInferos() {
        String modId = new ForgeJoiner(new String[]{"adinferos"}).setFor(GameVersions.V7, new String[]{"dextersnether"}).toString();
        String wither = "wither";
        String netherite = "netherite";
        String dimensional = "dimensional";
        if (GameVersions.V7.isRunning()) {
            String ore = "ore";
            String oreDarkStone = "ore_darkstone";
            Finders.GEMS.definitions.forMod(modId).withSuffixes(ore, oreDarkStone).addOre(wither, -16777216);
            Finders.METALS.definitions.forMod(modId).withSuffixes(ore, oreDarkStone).addOre(netherite, -10518914).withSuffixes("ore_nether").addOre(Ores.GOLD);
            Finders.MINERALS.definitions.forMod(modId).withSuffixes(ore).addOre(dimensional, -12438925);
        } else {
            Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(wither, 0, -16777216, -16777216);
            Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.GOLD).addOres(netherite, 0, -10518914, -10518914);
            Finders.MINERALS.definitions.forMod(modId).addOre("dimstone", -15000805).withOreSuffix().addOre("soul", -4804694).addOre(dimensional, -12438925).addOre("peat", -9029631);
        }
    }

    public static void initAstralSorcery() {
        String modId = "astralsorcery";
        String ore = new ForgeJoiner(new String[]{"block", "custom", "ore"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        String sandOre = new ForgeJoiner(new String[]{"block", "custom", "sand", "ore"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOre(sandOre, -14251544, "aquamarine").addOre(ore, 0, -1, "crystal_rock");
        Finders.METALS.definitions.forMod(modId).addOre(ore, 1, -16770200, "starmetal");
    }

    public static void initEmbers() {
        String modId = "embers";
        Finders.METALS.definitions.forMod(modId).withOrePrefix().addOre(Ores.COPPER).addOre(Ores.LEAD).addOre(Ores.SILVER.getName(), -4665644);
        Finders.GEMS.definitions.forMod(modId).withOrePrefix().addOre(Ores.QUARTZ);
    }

    public static void initEvilCraft() {
        String ore = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"dark", "ore"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod("evilcraft").addOres(ore, 0, -16777216, -16777216);
    }

    public static void initLotOfThings() {
        String modId = new ForgeJoiner(new String[]{"l", "o", "t"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Ores.RUBY);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.COPPER);
    }

    public static void initNuclearCraft() {
        String modId = new ForgeJoiner(new String[]{"nuclear", "craft"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"blockOre"}).toString();
        boolean isV7 = GameVersions.V7.isRunning();
        Finders.METALS.definitions.forMod(modId).addOre(ore, 0, -9742266, Ores.COPPER.getName()).addOre(ore, 1, -4276534, Ores.TIN.getName()).addOre(ore, 2, -10984865, Ores.LEAD.getName()).addOre(ore, isV7 ? 5 : 3, -11119274, "thorium").addOre(ore, 4, -12889818, Ores.URANIUM.getName()).addOre(ore, isV7 ? 8 : 5, -12566464, "boron").addOre(ore, isV7 ? 7 : 6, -3355444, "lithium").addOre(ore, isV7 ? 9 : 7, -2569518, "magnesium");
        if (isV7) {
            Finders.METALS.definitions.addOre(ore, 3, Ores.SILVER).addOre(ore, 6, -9408380, "plutonium");
        }
    }

    public static void initExtremeReactors() {
        String modId = "bigreactors";
        String materialName = "brore";
        Finders.GEMS.definitions.forMod(modId).addOre(materialName, 1, -752640, "anglesite").addOre(materialName, 2, -15796511, "benitoite");
        Finders.METALS.definitions.forMod(modId).addOre(materialName, 0, -724736, "yellorite");
    }

    public static void initTAIGA() {
        String modId = "taiga";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre("lignite", -12963543).addOre("slagiron", Ores.IRON).addOre("slaggold", Ores.GOLD).addOre("titanite", -3109201).addOre("meteorite", -12106697).addOre("vibranium", -6048081).addOre("adamantite", -6077499).addOre("prometheum", -15988462).addOre("rubium", -6080716).addOre("tiberium", -13990609).addOre("arcanite", -13354621).addOre("eternite", -2042829).addOre("mythril", -9007994).addOre("palladium", -445435).addOre("ignitite", -3239599).addOre("violium", -9925747).addOre("bismuth", -7315582).addOre("mindorite", -15550789).addOre("karmesine", -6598576);
    }

    public static void initArsMagica2() {
        String modId = "arsmagica2";
        String ore = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"vinteumOre"}).toString();
        Finders.GEMS.definitions.forMod(modId).addOre(ore, 1, -2251313, "chimerite").addOre(ore, 2, -11430465, "bluetopaz").addOre(ore, 3, -6042400, "moonstone").addOre(ore, 4, -5028302, "sunstone");
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, -13743909, "vinteum");
    }

    public static void initDeepResonance() {
        String modId = "deepresonance";
        String ore = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"resonating", "ore"}).reverseWordsOrderFor(GameVersions.V7).oreDictFormatFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOres(ore, 0, -695967, -695967, -695967);
    }

    public static void initSimpleOres() {
        String modId = "simpleores";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre("onyx", -15132391);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.COPPER).addOre(Ores.TIN).addOre(Ores.MYTHRIL).addOre("adamantium", -16745727);
    }

    public static void initIndustrialCraft2() {
        String modId = new ForgeJoiner(new String[]{"i", "c", "2"}).capitalizeWordsFor(GameVersions.V7).toString();
        if (GameVersions.V7.isRunning()) {
            Finders.METALS.definitions.forMod(modId).withNoDelimiters().withPrefixes("blockOre").addOre("Copper", Ores.COPPER).addOre("Lead", -8548715, Ores.LEAD.getName()).addOre("Tin", Ores.TIN).addOre("Uran", -9318638, Ores.URANIUM.getName());
        } else {
            String resource = "resource";
            Finders.METALS.definitions.forMod(modId).addOres(resource, 1, Ores.COPPER).addOre(resource, 2, -8548715, Ores.LEAD.getName()).addOres(resource, 3, Ores.TIN).addOre(resource, 4, -9318638, Ores.URANIUM.getName());
        }
    }

    public static void initTerraqueous() {
        String ore = "earth_ore";
        Finders.GEMS.definitions.forMod("terraqueous").addOre(ore, -14838924, "endimium").addOre(ore, 1, -2852330, "burnium");
    }

    public static void initRFTools() {
        String ore = new ForgeJoiner(new String[]{"dimensional_shard_ore"}).setFor(GameVersions.V7, new String[]{"dimensionalShardBlock"}).toString();
        Finders.GEMS.definitions.forMod("rftools").addOre(ore, -6489351, "dimensional_shard");
    }

    public static void initAppliedEnergistics2() {
        String modId = "appliedenergistics2";
        String quartz = new ForgeJoiner(new String[]{Ores.QUARTZ.getName()}).capitalizeWordsFor(GameVersions.V7).toString();
        String charged = new ForgeJoiner(new String[]{"charged"}).capitalizeWordsFor(GameVersions.V7).toString();
        int color = -6963731;
        if (GameVersions.V7.isRunning()) {
            Finders.GEMS.definitions.forMod(modId).withNoDelimiters().withPrefixes("tile.Ore").withSuffixes("", charged).addOre(quartz, color, Ores.QUARTZ.getName());
        } else {
            Finders.GEMS.definitions.forMod(modId).withPrefixes(charged, "").withOreSuffix().addOre(quartz, color);
        }
    }

    public static void initQuantumFlux() {
        String modId = "quantumflux";
        String ore = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"graphite", "ore"}).oreDictFormatFor(GameVersions.V10).toString();
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, -15132391, "graphite");
        if (GameVersions.V7.isRunning()) {
            Finders.METALS.definitions.forMod(modId).addOre("titaniumOre", -16747837, "titanium");
        }
    }

    public static void initProjectRed() {
        String modId = new ForgeJoiner(new String[]{"projectred-exploration"}).setFor(GameVersions.V7, new String[]{"ProjRed|Exploration"}).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"projectred.exploration.ore"}).toString();
        Finders.GEMS.definitions.forMod(modId).addOre(ore, -8249569, Ores.RUBY.getName()).addOre(ore, 1, -13485924, Ores.SAPPHIRE.getName()).addOre(ore, 2, -10640568, Ores.PERIDOT.getName());
        Finders.METALS.definitions.forMod(modId).addOre(ore, 3, -2651850, Ores.COPPER.getName()).addOre(ore, 4, -1710619, Ores.TIN.getName()).addOre(ore, 5, -6375727, Ores.SILVER.getName());
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, 6, -15768403, "electrotin");
    }

    public static void initPracticalLogistics2() {
        String modId = new ForgeJoiner(new String[]{"practicallogistics2"}).setFor(GameVersions.V7, new String[]{"PracticalLogistics"}).toString();
        ForgeJoiner.Delimiter delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7);
        String ore = new ForgeJoiner(delimiter, new String[]{"sapphire", "ore"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOre(ore, -15708569, Ores.SAPPHIRE.getName());
    }

    public static void initMekanism() {
        String modId = new ForgeJoiner(new String[]{"mekanism"}).capitalizeWordsFor(GameVersions.V7).toString();
        ForgeJoiner.Delimiter delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7);
        String ore = new ForgeJoiner(delimiter, new String[]{"ore", "block"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, Ores.OSMIUM, Ores.COPPER, Ores.TIN);
    }

    public static void initGeoActivity() {
        String prefix = new ForgeJoiner(new String[]{""}).setFor(GameVersions.V7, new String[]{"geoactivitytile."}).toString();
        Finders.MINERALS.definitions.forMod("geoactivity").withNoDelimiters().withPrefixes(prefix).withOreSuffix().addOre("lignite", -7119360).addOre("bituminous", -568064).addOre("anthracite", -3604480);
    }

    public static void initSaltyMod() {
        String salt = "salt";
        String modId = new ForgeJoiner(new String[]{salt, "mod"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = ForgeJoiner.withRegNameDelimiters((String[])new String[]{salt, "ore"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        String lake = ForgeJoiner.withRegNameDelimiters((String[])new String[]{salt, "lake"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, -5323338, salt).addOre(lake, -5323338, salt);
    }

    public static void initTheBetweenlands() {
        String modId = "thebetweenlands";
        ForgeJoiner.Delimiter delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7);
        String middleGemOre = new ForgeJoiner(delimiter, new String[]{"middle", "gem", "ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        String lifeCrystal = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"life", "crystal"}).oreDictFormatFor(GameVersions.V7).toString();
        String slimyBone = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"slimy", "bone"}).setFor(GameVersions.V7, new String[]{"bone"}).toString();
        Finders.GEMS.definitions.forMod(modId).withDelimiter(delimiter.toString()).withSuffixes(ore).addOre(lifeCrystal, -1385504).addOre("valonite", -6257760).addOre("scabyst", -13009552).withSuffixes(middleGemOre).addOre("aqua", -16645382).addOre("crimson", -1769472).addOre("green", -16730624);
        Finders.METALS.definitions.forMod(modId).withDelimiter(delimiter.toString()).withSuffixes(ore).addOre("octine", -365568).addOre("syrmorite", -11445076);
        Finders.MINERALS.definitions.forMod(modId).withDelimiter(delimiter.toString()).withSuffixes(ore).addOre("sulfur", -789760).addOre(slimyBone, -16680447);
    }

    public static void initAether2() {
        String modId = "aether";
        String delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).withDelimiter(delimiter).withSuffixes(ore).addOre("ambrosium", -2175115).addOre("zanite", -12638088).addOre("icestone", -7822107).addOre("continuum", -2134737);
        Finders.METALS.definitions.forMod(modId).withDelimiter(delimiter).withSuffixes(ore).addOre("gravitite", -6665853).addOre("arkenium", -15132391);
    }

    public static void initThaumcraft() {
        String modId = new ForgeJoiner(new String[]{"thaumcraft"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"block", "custom", "ore"}).oreDictFormatFor(GameVersions.V7).toString();
        String stone = "infused_stone";
        Finders.GEMS.definitions.forMod(modId).withNoDelimiters().addOre(ore, 1, -9610464, "air_" + stone).addOre(ore, 2, -9693952, "fire_" + stone).addOre(ore, 3, -16764095, "water_" + stone).addOre(ore, 4, -16762624, "earth_" + stone).addOre(ore, 5, -10074047, "order_" + stone).addOre(ore, 6, -14476003, "entropy_" + stone);
        Finders.MINERALS.definitions.forMod(modId).withNoDelimiters().addOre(ore, 0, -10551296, "cinnabar");
    }

    public static void initAetherLegacy() {
        String modId = "aether_legacy";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre("ambrosium", Short.MAX_VALUE, -2175115).addOre("zanite", -12638088);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre("gravitite", -6665853);
    }

    public static void initRealWorld() {
        String modId = "realworld";
        Finders.GEMS.definitions.forMod(modId).withOrePrefix().addOres(Ores.AMETHYST, Ores.CITRINE, Ores.PERIDOT, Ores.MELANITE, Ores.GARNET, Ores.TOPAZ, Ores.RUBY).addOre(Ores.SAPPHIRE.getName(), -16769095).addOre(Ores.TANZANITE.getName(), -16742450);
    }

    public static void initSimpleOreGeneration() {
        String modId = "simpleoregen";
        String[] prefixes = new String[]{"surface", "nether", "end"};
        String delimiter = ForgeJoiner.Delimiter.none().toString();
        String suffix = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V10).toString();
        int meta = 0;
        boolean capitalized = GameVersions.getCurrent() == GameVersions.V10;
        Finders.GEMS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOres(capitalized, Ores.DIAMOND, Ores.EMERALD, Ores.LAPIS, Ores.QUARTZ);
        Finders.METALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOres(capitalized, Ores.IRON, Ores.GOLD).addOre(capitalized, meta, -2046559, Ores.COPPER).addOre(capitalized, meta, -6058837, Ores.LEAD).addOre(capitalized, meta, -10714060, Ores.NICKEL).addOre(capitalized, meta, -5855578, Ores.SILVER).addOre(capitalized, meta, -1907998, Ores.TIN).addOre(capitalized, meta, -8922349, Ores.URANIUM);
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOres(capitalized, Ores.COAL, Ores.REDSTONE).addOre(capitalized, meta, -8365538, Ores.BAUXITE);
    }

    public static void initNetherEx() {
        String modId = "nex";
        String ore = "ore";
        int quartzColor = Ores.QUARTZ.getARGB();
        String prefix = new ForgeJoiner(new String[]{ore}).setFor(GameVersions.V10, new String[]{""}).toString();
        String suffix = new ForgeJoiner(new String[]{""}).setFor(GameVersions.V10, new String[]{ore}).toString();
        Finders.GEMS.definitions.forMod(modId).withPrefixes(prefix).withSuffixes(suffix).addOres("quartz", 0, quartzColor, quartzColor, quartzColor, quartzColor).addOre("amethyst", -9490548).addOre("rime", -8622147);
    }

    public static void initIceAndFire() {
        String modId = "iceandfire";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ores.SILVER);
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Ores.SAPPHIRE.getName(), -15912032);
    }

    public static void initSteamEnginesMod() {
        String modId = "sem";
        String regName = "erze";
        Finders.METALS.definitions.forMod(modId).addOre(regName, 0, -5921371, Ores.TIN.getName()).addOre(regName, 1, -7355699, Ores.ZINC.getName()).addOre(regName, 2, -2195634, Ores.COPPER.getName()).addOre(regName, 4, -10161396, "devils");
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, 3, -723724, "salt").addOre(regName, 5, Ores.SULFUR).addOre(regName, 6, Ores.COAL);
    }
}

