/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ForgeGui
implements IGuiHandler {
    private final ForgeMod mod;

    public ForgeGui(ForgeMod mod) {
        this.mod = mod;
        mod.getRegistrator().addGuiHandler(this);
    }

    public void openFor(EntityPlayer player, int guiId, BlockPos pos) {
        if (ForgeEntity.isClientSide((Entity)player)) {
            player.openGui((Object)this.mod, guiId, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract class Screen
    extends GuiScreen {
        private Dimension controlSize = new Dimension(150, 20);
        private int controlIndent = 5;
        private int columnsAmount = 1;
        private List<Gui> controlList = new ArrayList<Gui>();
        private GuiButtonExt buttonAccept;
        private GuiButtonExt buttonCancel;

        public void func_73866_w_() {
            this.addFinalButtons();
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void bindTexture(ResourceLocation texture) {
            this.field_146297_k.func_110434_K().func_110577_a(texture);
        }

        public void close() {
            this.field_146297_k.func_71381_h();
        }

        public Point getBasePoint(Dimension textureSize) {
            return new Point((this.field_146294_l - textureSize.width) / 2, (this.field_146295_m - textureSize.height) / 2);
        }

        protected int getControlsAmount() {
            return this.controlList.size();
        }

        protected Rectangle getControlRect(int controlId) {
            int col = Math.floorMod(controlId, this.getColumnsAmount());
            int x = (this.field_146294_l - this.controlSize.width * this.getColumnsAmount() - this.controlIndent * (this.getColumnsAmount() - 1)) / 2 + (this.controlSize.width + this.controlIndent) * col;
            int rowsAmount = this.getControlsAmount() / this.getColumnsAmount() + 1;
            int row = controlId / this.getColumnsAmount();
            int y = (this.field_146295_m - this.controlSize.height * rowsAmount - this.controlIndent * (rowsAmount - 1)) / 2 + (this.controlSize.height + this.controlIndent) * row;
            return new Rectangle(new Point(x, y), this.controlSize);
        }

        protected int getNextControlId() {
            return this.controlList.size();
        }

        public GuiButtonExt addButton(String label) {
            Rectangle rect = this.getControlRect(this.getNextControlId());
            GuiButtonExt button = new GuiButtonExt(this.getNextControlId(), rect.x, rect.y, rect.width, rect.height, label);
            this.addControl((Gui)button);
            return button;
        }

        public GuiSlider addSlider(String label, FloatBounds bounds, float value, @Nullable GuiSlider.ISlider handler) {
            Rectangle rect = this.getControlRect(this.getNextControlId());
            GuiSlider slider = new GuiSlider(this.getNextControlId(), rect.x, rect.y, rect.width, rect.height, this.getFormatedLabel(label), "", (double)bounds.min.floatValue(), (double)bounds.max.floatValue(), (double)value, true, true, handler);
            slider.precision = 2;
            slider.updateSlider();
            this.addControl((Gui)slider);
            return slider;
        }

        public GuiSlider addSlider(String label, IntBounds bounds, int value, @Nullable GuiSlider.ISlider handler) {
            Rectangle rect = this.getControlRect(this.getNextControlId());
            GuiSlider slider = new GuiSlider(this.getNextControlId(), rect.x, rect.y, rect.width, rect.height, this.getFormatedLabel(label), "", (double)bounds.min.intValue(), (double)bounds.max.intValue(), (double)value, false, true, handler);
            this.addControl((Gui)slider);
            return slider;
        }

        public GuiLabel addLabel(String text, int color) {
            Rectangle rect = this.getControlRect(this.getNextControlId());
            GuiLabel label = new GuiLabel(this.field_146289_q, this.getNextControlId(), rect.x, rect.y, rect.width, rect.height, color);
            label.func_175202_a(text);
            label.func_175203_a();
            this.addControl((Gui)label);
            return label;
        }

        public GuiCheckBox addCheckBox(String label, boolean checked) {
            Rectangle rect = this.getControlRect(this.getNextControlId());
            GuiCheckBox checkbox = new GuiCheckBox(this.getNextControlId(), rect.x, rect.y, label, checked);
            checkbox.field_146120_f = rect.width;
            checkbox.field_146121_g = rect.height;
            this.addControl((Gui)checkbox);
            return checkbox;
        }

        protected String getFormatedLabel(String label) {
            return label + ": ";
        }

        protected void addControl(Gui control) {
            this.controlList.add(control);
            if (control instanceof GuiButton) {
                this.field_146292_n.add((GuiButton)control);
            } else if (control instanceof GuiLabel) {
                this.field_146293_o.add((GuiLabel)control);
            }
            for (int i = 0; i < this.controlList.size(); ++i) {
                Rectangle rect = this.getControlRect(i);
                Gui element = this.controlList.get(i);
                if (element instanceof GuiButton) {
                    ((GuiButton)element).field_146128_h = rect.x;
                    ((GuiButton)element).field_146129_i = rect.y;
                    continue;
                }
                if (!(element instanceof GuiLabel)) continue;
                ((GuiLabel)element).field_146162_g = rect.x;
                ((GuiLabel)element).field_146174_h = rect.y;
            }
        }

        public void addFinalButtons() {
            while (Math.floorMod(this.getControlsAmount(), this.getColumnsAmount()) + 1 != Math.max(1, this.getColumnsAmount() - 1)) {
                this.addControl(null);
            }
            this.buttonAccept = this.addButton(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
            this.buttonCancel = this.addButton(I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        }

        protected void func_146284_a(GuiButton button) throws IOException {
            if (button == this.buttonAccept) {
                this.onAccept();
                this.close();
            } else if (button == this.buttonCancel) {
                this.close();
            }
        }

        protected abstract void onAccept();

        public int getColumnsAmount() {
            return this.columnsAmount;
        }

        public void setColumnsAmount(int columnsAmount) {
            this.columnsAmount = columnsAmount;
        }
    }
}

