/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.ChunkLoc;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ForgeNetMsg<MSG extends ForgeNetMsg<MSG>>
implements IMessage,
IMessageHandler<MSG, IMessage> {
    private static final Map<Class<?>, FieldHandler<?>> fieldHandlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!ForgeNetMsg.acceptField(field)) continue;
                this.readField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!ForgeNetMsg.acceptField(field)) continue;
                this.writeField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsValue(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        fieldCache.put(clazz, fields);
        return fields;
    }

    private final void writeField(Field field, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
        handler.writer.write(field.get(this), buf);
    }

    private final void readField(Field field, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
        field.set(this, handler.reader.read(buf));
    }

    private static FieldHandler<?> getFieldHandler(Class<?> clazz) {
        FieldHandler<?> handler = fieldHandlers.get(clazz);
        if (handler == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return handler;
    }

    private static boolean acceptField(Field field) {
        Class<?> type = field.getType();
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return fieldHandlers.containsKey(type);
    }

    public static <T> void addFieldHandler(Class<T> type, IReader<T> reader, IWriter<T> writer) {
        fieldHandlers.put(type, new FieldHandler<T>(reader, writer));
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Nullable
    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.side.isClient() ? this.getClientPlayer() : ctx.getServerHandler().field_147369_b;
    }

    @Nullable
    public World getWorld(MessageContext ctx) {
        EntityPlayer player = this.getPlayer(ctx);
        return player != null ? player.field_70170_p : null;
    }

    @Nullable
    public Entity findEntity(MessageContext ctx, int id) {
        return ForgeWorld.findEntity(this.getWorld(ctx), id);
    }

    public boolean isServerSide(MessageContext ctx) {
        return ctx.side.isServer();
    }

    public boolean isClientSide(MessageContext ctx) {
        return ctx.side.isClient();
    }

    public Block getBlock(MessageContext ctx, BlockPos pos) {
        return ForgeWorld.getBlock(this.getWorld(ctx), pos);
    }

    static {
        ForgeNetMsg.addFieldHandler(Byte.TYPE, buf -> buf.readByte(), (value, buf) -> buf.writeByte((int)value.byteValue()));
        ForgeNetMsg.addFieldHandler(Short.TYPE, buf -> buf.readShort(), (value, buf) -> buf.writeShort((int)value.shortValue()));
        ForgeNetMsg.addFieldHandler(Integer.TYPE, buf -> buf.readInt(), (value, buf) -> buf.writeInt(value.intValue()));
        ForgeNetMsg.addFieldHandler(Long.TYPE, buf -> buf.readLong(), (value, buf) -> buf.writeLong(value.longValue()));
        ForgeNetMsg.addFieldHandler(Float.TYPE, buf -> Float.valueOf(buf.readFloat()), (value, buf) -> buf.writeFloat(value.floatValue()));
        ForgeNetMsg.addFieldHandler(Double.TYPE, buf -> buf.readDouble(), (value, buf) -> buf.writeDouble(value.doubleValue()));
        ForgeNetMsg.addFieldHandler(Boolean.TYPE, buf -> buf.readBoolean(), (value, buf) -> buf.writeBoolean(value.booleanValue()));
        ForgeNetMsg.addFieldHandler(Character.TYPE, buf -> Character.valueOf(buf.readChar()), (value, buf) -> buf.writeChar((int)value.charValue()));
        ForgeNetMsg.addFieldHandler(String.class, buf -> ByteBufUtils.readUTF8String((ByteBuf)buf), (string, buf) -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string));
        ForgeNetMsg.addFieldHandler(NBTTagCompound.class, buf -> ForgeNBT.readFromByteBuf(buf), (compound, buf) -> ForgeNBT.writeToByteBuf(compound, buf));
        ForgeNetMsg.addFieldHandler(ItemStack.class, buf -> ByteBufUtils.readItemStack((ByteBuf)buf), (stack, buf) -> ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack));
        ForgeNetMsg.addFieldHandler(BlockPos.class, buf -> BlockPos.func_177969_a((long)buf.readLong()), (pos, buf) -> buf.writeLong(pos.func_177986_g()));
        ForgeNetMsg.addFieldHandler(Vect3d.class, buf -> Vect3d.readFromByteBuf(buf), (vec, buf) -> Vect3d.writeToByteBuf(vec, buf));
        ForgeNetMsg.addFieldHandler(ChunkLoc.class, buf -> ChunkLoc.fromLong(buf.readLong()), (loc, buf) -> buf.writeLong(loc.toLong()));
        ForgeNetMsg.addFieldHandler(Block.class, buf -> Block.func_149729_e((int)buf.readInt()), (block, buf) -> buf.writeInt(Block.func_149682_b((Block)block)));
    }

    public static interface IReader<T> {
        public T read(ByteBuf var1);
    }

    public static interface IWriter<T> {
        public void write(T var1, ByteBuf var2);
    }

    private static class FieldHandler<T> {
        public final IReader<T> reader;
        public final IWriter<T> writer;

        public FieldHandler(IReader<T> reader, IWriter<T> writer) {
            this.reader = reader;
            this.writer = writer;
        }
    }
}

