/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.regs;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.materials.SmeltingRecipe;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.ForgeBlockContainer;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.IRelatedUnitId;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

public class ForgeRegistrator {
    public static final String FORMAT_REGISTERED = "registered: <{}>";
    public static final String FORMAT_REMAINS_UNREGISTERED = "remains UNREGISTERED: <{}>";
    public static final String FORMAT_SKIPPED = "SKIPPED: <{}>";
    public static final String FORMAT_INVALID = "INVALID: <{}>";
    public static final String FORMAT_NOT_FOUND = "NOT FOUND: <{}>";
    public static final String FORMAT_ALREADY_REGISTERED = "ALREADY REGISTERED: <{}>";
    private final ForgeMod mod;
    public final SimpleNetworkWrapper networkChannel;
    protected int discriminator = 0;
    protected List<IForgeUnit> unregisteredUnits = new ArrayList<IForgeUnit>();
    protected List<IForgeUnit> registeredUnits = new ArrayList<IForgeUnit>();
    protected Map<CraftingRecipe, CraftingRecipe> craftings = new HashMap<CraftingRecipe, CraftingRecipe>();
    protected List<SmeltingRecipe> smeltings = new ArrayList<SmeltingRecipe>();
    protected List<IGuiHandler> guiHandlers = new ArrayList<IGuiHandler>();

    public ForgeRegistrator(ForgeMod mod) {
        this.mod = mod;
        this.networkChannel = NetworkRegistry.INSTANCE.newSimpleChannel(mod.getId());
    }

    public void addUnit(IForgeUnit unit) {
        this.unregisteredUnits.add(unit);
    }

    public void addGuiHandler(IGuiHandler handler) {
        this.guiHandlers.add(handler);
    }

    public void addBlockCrafting(String itemId, String blockId) {
        CraftingRecipe recipe = new CraftingRecipe("111 111 111", blockId, 1, itemId);
        this.addCrafting(recipe);
    }

    public void addBlockCrafting(IForgeUnit item, IForgeUnit block) {
        this.addBlockCrafting(item.getStringId(), block.getStringId());
    }

    protected void registerGiuHandlers() {
        Iterator<IGuiHandler> iterator = this.guiHandlers.iterator();
        while (iterator.hasNext()) {
            IGuiHandler handler = iterator.next();
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)this.mod, handler);
            iterator.remove();
        }
    }

    private Logger getLogger() {
        return this.mod.getLogger();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void registerUnits(Side side) {
        String format = "registered: <{}> as {}";
        Iterator<IForgeUnit> iterator = this.unregisteredUnits.iterator();
        while (true) {
            block16: {
                IForgeUnit unit;
                block14: {
                    block15: {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        unit = iterator.next();
                        if (unit == null) break block14;
                        if (!unit.isReadyToRegister()) break block15;
                        if (unit.isEnabled()) {
                            ResourceLocation location = unit.getId().toResLoc();
                            if (unit instanceof Block) {
                                Block block = (Block)unit;
                                GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)location);
                                ItemBlock itemBlock = unit instanceof ForgeBlock ? ((ForgeBlock)block).createItemBlock() : new ItemBlock(block);
                                GameRegistry.register((IForgeRegistryEntry)itemBlock.setRegistryName(location));
                                if (side == Side.CLIENT) {
                                    this.registerItemModel((Item)itemBlock);
                                }
                                if (!(unit instanceof IRelatedUnitId)) {
                                    OreDictionary.registerOre((String)unit.getId().getDictName(), (Block)block);
                                }
                                if (unit instanceof ForgeBlockContainer) {
                                    ForgeBlockContainer container = (ForgeBlockContainer)unit;
                                    GameRegistry.registerTileEntity(container.getTileEntityClass(), (String)container.getTileEntityId().toString());
                                }
                                this.getLogger().info("registered: <{}> as {}", new Object[]{unit.getId(), block.toString()});
                            } else if (unit instanceof Item) {
                                Item item = (Item)unit;
                                GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)location);
                                if (side == Side.CLIENT) {
                                    this.registerItemModel(item);
                                }
                                if (!(unit instanceof IRelatedUnitId)) {
                                    OreDictionary.registerOre((String)unit.getId().getDictName(), (Item)item);
                                }
                                this.getLogger().info("registered: <{}> as {}", new Object[]{unit.getId(), item.toString()});
                            } else {
                                this.getLogger().error("FAILED to register: '{}' is neither block nor item!", new Object[]{unit.getId()});
                            }
                            if (unit.isRegistered()) {
                                this.registeredUnits.add(unit);
                            }
                            break block16;
                        } else {
                            this.getLogger().info(FORMAT_SKIPPED, new Object[]{unit});
                        }
                        break block16;
                    }
                    this.getLogger().info(FORMAT_SKIPPED, new Object[]{unit});
                    continue;
                }
                this.getLogger().error(FORMAT_SKIPPED, new Object[]{IForgeUnit.getStatus(unit)});
            }
            iterator.remove();
        }
    }

    public void addCrafting(CraftingRecipe recipe) {
        this.addCrafting(recipe, null);
    }

    public void addCrafting(CraftingRecipe main, CraftingRecipe reserve) {
        this.craftings.put(main, reserve);
    }

    public void addSmelting(SmeltingRecipe recipe) {
        this.smeltings.add(recipe);
    }

    protected void processInits(Side side) {
        Iterator<IForgeUnit> iterator = this.registeredUnits.iterator();
        while (iterator.hasNext()) {
            IForgeUnit unit = iterator.next();
            if (unit != null) {
                if (unit.isRegistered()) {
                    unit.onInit();
                    if (side == Side.CLIENT) {
                        unit.onInitClient();
                    }
                } else {
                    this.getLogger().error("Attempt to init NOT REGISTERED unit: {}", new Object[]{unit});
                }
            }
            iterator.remove();
        }
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.registerUnits(event.getSide());
    }

    public void onInit(FMLInitializationEvent event) {
        this.registerUnits(event.getSide());
        this.registerRecipes(false);
        this.registerGiuHandlers();
        this.processInits(event.getSide());
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.registerUnits(event.getSide());
        this.registerRecipes(false);
        this.registerRecipes(true);
        this.processInits(event.getSide());
        for (IForgeUnit iForgeUnit : this.unregisteredUnits) {
            this.getLogger().info(FORMAT_REMAINS_UNREGISTERED, new Object[]{iForgeUnit});
        }
        for (Map.Entry entry : this.craftings.entrySet()) {
            this.getLogger().info(FORMAT_REMAINS_UNREGISTERED, new Object[]{"MAIN: " + entry.getKey() + ", RESERVE: " + entry.getValue()});
        }
        for (SmeltingRecipe smeltingRecipe : this.smeltings) {
            this.getLogger().info(FORMAT_REMAINS_UNREGISTERED, new Object[]{smeltingRecipe});
        }
        this.unregisteredUnits.clear();
        this.registeredUnits.clear();
        this.craftings.clear();
        this.smeltings.clear();
    }

    public <M extends IMessage, H extends IMessageHandler<M, IMessage>> void registerNetMessageForClient(Class<M> msgClass, H msgHandler) {
        this.networkChannel.registerMessage(msgHandler, msgClass, this.discriminator++, Side.CLIENT);
    }

    public <M extends IMessage, H extends IMessageHandler<M, IMessage>> void registerNetMessageForServer(Class<M> msgClass, H msgHandler) {
        this.networkChannel.registerMessage(msgHandler, msgClass, this.discriminator++, Side.SERVER);
    }

    public <M extends IMessage, H extends IMessageHandler<M, IMessage>> void registerNetMessageForBothSides(Class<M> msgClass, H msgHandler) {
        this.registerNetMessageForClient(msgClass, msgHandler);
        this.registerNetMessageForServer(msgClass, msgHandler);
    }

    public void registerInEventBus(Object target) {
        MinecraftForge.EVENT_BUS.register(target);
    }

    public <T extends Entity> void registerRenderingHandler(Class<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    protected void registerRecipes(boolean useReserve) {
        this.registerCraftings(useReserve);
        this.registerSmeltings();
    }

    protected void registerCraftings(boolean useReserve) {
        Iterator<Map.Entry<CraftingRecipe, CraftingRecipe>> iterator = this.craftings.entrySet().iterator();
        while (iterator.hasNext()) {
            CraftingRecipe recipe;
            Map.Entry<CraftingRecipe, CraftingRecipe> entry = iterator.next();
            CraftingRecipe craftingRecipe = recipe = useReserve ? entry.getValue() : entry.getKey();
            if (recipe != null && recipe.isValid()) {
                if (!recipe.isReadyToRegister()) continue;
                if (recipe.isShapeless()) {
                    GameRegistry.addShapelessRecipe((ItemStack)recipe.getOutputStack().toItemStack(), (Object[])recipe.getParams());
                } else {
                    GameRegistry.addShapedRecipe((ItemStack)recipe.getOutputStack().toItemStack(), (Object[])recipe.getParams());
                }
                iterator.remove();
                continue;
            }
            if (recipe == null) continue;
            this.getLogger().error(FORMAT_INVALID, new Object[]{recipe});
            iterator.remove();
        }
    }

    protected void registerSmeltings() {
        Iterator<SmeltingRecipe> iterator = this.smeltings.iterator();
        while (iterator.hasNext()) {
            SmeltingRecipe recipe = iterator.next();
            if (recipe != null && recipe.isValid()) {
                if (!recipe.isReadyToRegister()) continue;
                GameRegistry.addSmelting((ItemStack)recipe.getInputStack().toItemStack(), (ItemStack)recipe.getOutputStack().toItemStack(), (float)recipe.getSmeltingData().getXp());
                iterator.remove();
                continue;
            }
            if (recipe == null) continue;
            this.getLogger().error(FORMAT_INVALID, new Object[]{recipe});
            iterator.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item) {
        Block block;
        IForgeUnit unit = null;
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof IForgeUnit) {
            unit = (IForgeUnit)block;
        }
        if (item instanceof IForgeUnit) {
            unit = (IForgeUnit)item;
        }
        if (unit != null) {
            ItemMeshDefinition definition = unit.getItemMeshDefinition();
            if (definition != null) {
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
                for (UnitVariant variant : unit.getUnitVariants()) {
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{variant.toModelResLoc()});
                }
            } else {
                for (UnitVariant variant : unit.getUnitVariants()) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.getId().getMeta(), (ModelResourceLocation)variant.toModelResLoc());
                }
            }
        } else {
            UnitId id = UnitId.from(item);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)id.getMeta(), (ModelResourceLocation)id.toModelResLoc_Inventory());
        }
    }

    public <T extends Entity> void registerEntity(ForgeMod mod, Class<T> entityClass, int trackingRange, int updateFrequency, boolean sendVelocity) {
        String entityName = entityClass.getSimpleName();
        ResourceLocation registryName = UnitId.from(mod.getId(), entityName).toResLoc();
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)entityName, (int)this.discriminator++, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
    }
}

