/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeItemBlock;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeBlock
extends Block
implements IForgeUnit {
    private final UnitEnabled unitEnabled;
    private final ForgeConfig config;
    private final ForgeMod mod;
    private final UnitId id;
    private UnitVariant[] variants;

    public ForgeBlock(ForgeMod mod, UnitConfig config, String name, Material material, CreativeTabs tab) {
        super(material);
        this.mod = mod;
        this.id = this.createId(mod.getId(), name);
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getConfigCategory(), true);
        this.variants = this.createUnitVariants();
        this.func_149663_c(this.getId().getRegName());
        this.func_149647_a(tab);
        this.getMod().getRegistrator().addUnit(this);
    }

    public ForgeBlock(ForgeMod mod, UnitConfig config, String name, Material material, float hardness, float resistance, CreativeTabs tab) {
        this(mod, config, name, material, tab);
        this.func_149711_c(hardness);
        this.setResistance(resistance);
    }

    @Nullable
    public static Block getBlockOrNull(Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).func_179223_d() : null;
    }

    public static String getStringId(Block block) {
        return UnitId.from(block, 0).toString();
    }

    public static <T extends Enum<T>> PropertyEnum<T> createPropertyEnum(Class<T> clazz) {
        return PropertyEnum.func_177709_a((String)IForgeUnit.getClassRegName(clazz), clazz);
    }

    public static UnitConfig createDefaultConfig(ForgeMod mod, String blockName) {
        Path baseDir = mod.getConfig().getConfigDir().resolve("blocks");
        String configName = UnitId.dictToRegName(blockName);
        return new UnitConfig(baseDir, configName);
    }

    public float getHardness() {
        return this.field_149782_v;
    }

    public float getResistance() {
        return this.field_149781_w;
    }

    public ForgeBlock setResistance(float resistance) {
        this.field_149781_w = resistance;
        return this;
    }

    public ForgeBlock setLightValue(int value) {
        this.field_149784_t = value;
        return this;
    }

    protected void explode(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        if (ForgeWorld.isServerSide(worldIn)) {
            EntityTNTPrimed tnt = new EntityTNTPrimed(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), igniter);
            worldIn.func_72838_d((Entity)tnt);
            worldIn.func_184148_a((EntityPlayer)null, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public String toString() {
        return ForgeBlock.class.getSimpleName() + Args.group(Args.get("status", IForgeUnit.getStatus(this)), Args.get("regName", this.getId().getRegName()), Args.get("enabled", this.isEnabled()), Args.get("hardness", Float.valueOf(this.getHardness())), Args.get("resistance", Float.valueOf(this.getResistance())), Args.get("harvestLevel", this.getHarvestLevel(this.func_176223_P())));
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    public static boolean isRegistered(Block block) {
        return Block.func_149682_b((Block)block) != -1;
    }

    @Override
    public boolean isRegistered() {
        return ForgeBlock.isRegistered(this);
    }

    @Override
    public void onInit() {
        float hardness = ForgeConfig.getFloat(this.getConfig(), this.getConfigCategory(), "hardness", this.getHardness(), new FloatBounds(Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE)), "Defines how many hits it takes to break the block.\n -1 makes the block indestructible.");
        float resistance = ForgeConfig.getFloat(this.getConfig(), this.getConfigCategory(), "resistance", this.getResistance(), new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)), "Defines the block resistance to explosions.");
        this.func_149711_c(hardness);
        this.setResistance(resistance);
        if (this.getConfig() != null) {
            this.getConfig().save();
        }
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    public boolean hasVariants() {
        return this.variants.length > 1;
    }

    @Override
    public UnitVariant[] getUnitVariants() {
        return this.variants;
    }

    public <T extends Enum<T>> void setUnitVariants(Class<T> clazz) {
        ArrayList<UnitVariant> list = new ArrayList<UnitVariant>();
        for (Enum en : (Enum[])clazz.getEnumConstants()) {
            UnitId id = this.getId().withMeta(en.ordinal());
            UnitVariant variant = UnitVariant.from(id, (IForgeEnum)((Object)en));
            list.add(variant);
        }
        this.variants = list.toArray(new UnitVariant[0]);
    }

    public ItemBlock createItemBlock() {
        ForgeItemBlock itemBlock = new ForgeItemBlock(this);
        itemBlock.func_77627_a(this.hasVariants());
        return itemBlock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }
}

