/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.units.ForgeStack;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Immutable
public class ItemState {
    public static final ItemState EMPTY = ItemState.from(null, 0);
    @Nullable
    private final Item item;
    private final int meta;

    protected ItemState(@Nullable Item item, int meta) {
        this.item = item;
        this.meta = meta;
    }

    public static ItemState from(@Nullable Item item, int meta) {
        return new ItemState(item, meta);
    }

    public static ItemState from(@Nullable Item item) {
        return ItemState.from(item, 0);
    }

    public static ItemState from(ItemStack stack) {
        return ItemState.from(stack.func_77973_b(), stack.func_77960_j());
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean exists() {
        return this.getItem() != null;
    }

    public boolean matches(ItemState state) {
        return state.getItem() == this.getItem() && UnitId.metasAreMatched(state.getMeta(), this.getMeta());
    }

    public int hashCode() {
        return Objects.hash(this.getItem(), this.getMeta());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemState) {
            ItemState state = (ItemState)obj;
            return state.getItem() == this.getItem() && state.getMeta() == this.getMeta();
        }
        return super.equals(obj);
    }

    public ItemStack toItemStack(int amount) {
        return new ItemStack(this.getItem(), amount, this.getMeta());
    }

    public ForgeStack toStack(int amount) {
        return ForgeStack.from(this, amount);
    }

    public String toString() {
        return (this.exists() ? this.getItem().func_77658_a() : "null") + "@" + this.getMeta();
    }

    public ItemState withMeta(int meta) {
        return ItemState.from(this.getItem(), meta);
    }

    public ItemState withMetaAll() {
        return this.withMeta(Short.MAX_VALUE);
    }
}

