/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class ChunkBounds {
    public static final int WIDTH = 16;
    public static final int SQUARE = 256;
    public static final int DEFAULT_HEIGHT = ForgeBounds.HEIGHT.getIntBounds().length() + 1;
    public static final int DEFAULT_CAPACITY = 256 * DEFAULT_HEIGHT;
    private final IntBounds x;
    private final IntBounds y;
    private final IntBounds z;

    public ChunkBounds(IntBounds x, IntBounds y, IntBounds z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static ChunkBounds from(ChunkPos pos, IntBounds y) {
        return new ChunkBounds(new IntBounds(pos.func_180334_c(), pos.func_180332_e()), y, new IntBounds(pos.func_180333_d(), pos.func_180330_f()));
    }

    public static ChunkBounds from(ChunkPos pos) {
        return ChunkBounds.from(pos, ForgeBounds.HEIGHT.getIntBounds());
    }

    public static ChunkBounds from(Chunk chunk, IntBounds y) {
        return ChunkBounds.from(chunk.func_76632_l(), y);
    }

    public static ChunkBounds from(Chunk chunk) {
        return ChunkBounds.from(chunk.func_76632_l());
    }

    public IntBounds getX() {
        return this.x;
    }

    public IntBounds getZ() {
        return this.z;
    }

    public IntBounds getY() {
        return this.y;
    }

    public int getHeight() {
        return this.getY().length() + 1;
    }

    public int getCapacity() {
        return 256 * this.getHeight();
    }

    public boolean encloses(BlockPos pos) {
        return this.getX().encloses(pos.func_177958_n()) && this.getY().encloses(pos.func_177956_o()) && this.getZ().encloses(pos.func_177952_p());
    }
}

