/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public enum Arrows {
    OVERHEAD(0.0, 1),
    UNDERFOOT(180.0, -1);

    private final CommonMath.Angle angle;
    public final int step;

    private Arrows(double degrees, int step) {
        this.angle = CommonMath.Angle.fromDegrees((double)degrees);
        this.step = step;
    }

    public Arrow create(ColorARGB color, TargetLocation location) {
        return new Arrow(color, location, this.angle);
    }

    class Arrow
    extends Indicator {
        private static final double SIZE = 0.15;
        private final CommonMath.Angle angle;

        public Arrow(ColorARGB color, TargetLocation location, CommonMath.Angle angle) {
            super(color, location);
            this.angle = angle;
        }

        @SideOnly(value=Side.CLIENT)
        public void draw(double scale) {
            double degrees = this.angle.getDegrees();
            double size = 0.15 * scale;
            GL11.glRotated((double)degrees, (double)0.0, (double)0.0, (double)1.0);
            GL11.glColor4f((float)this.getColor().getRed().toFloat(), (float)this.getColor().getGreen().toFloat(), (float)this.getColor().getBlue().toFloat(), (float)this.getColor().getAlpha().toFloat());
            GL11.glBegin((int)4);
            GL11.glVertex3d((double)0.0, (double)size, (double)0.0);
            GL11.glVertex3d((double)(-size), (double)(size / 2.0), (double)0.0);
            GL11.glVertex3d((double)size, (double)(size / 2.0), (double)0.0);
            GL11.glEnd();
            GL11.glRotated((double)(-degrees), (double)0.0, (double)0.0, (double)1.0);
        }
    }
}

