/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.minecraft.mods.adfinders.finder.Render;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class CustomRender
implements IItemRenderer {
    public static final int ICON_SIZE = 16;
    private static final RenderItem RENDER_ITEM = (RenderItem)RenderManager.field_78727_a.field_78729_o.get(EntityItem.class);

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        Item item = stack.func_77973_b();
        int renderPassesCount = item.getRenderPasses(stack.func_77960_j());
        Tessellator tess = Tessellator.field_78398_a;
        double scale = 1.0;
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslated((double)0.0, (double)0.0, (double)1.5);
                GL11.glRotated((double)60.0, (double)0.0, (double)1.0, (double)-0.2);
                GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
                break;
            }
        }
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                float offset = 0.01f;
                for (int pass = 0; pass < renderPassesCount; ++pass) {
                    IIcon icon = item.getIcon(stack, pass);
                    ItemRenderer.func_78439_a((Tessellator)tess, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)(0.08f - offset));
                }
                GL11.glTranslated((double)0.5, (double)0.5, (double)((double)-0.08f + (double)offset / 2.0));
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case INVENTORY: {
                GL11.glPushAttrib((int)8192);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                for (int pass = 0; pass < renderPassesCount; ++pass) {
                    IIcon icon = item.getIcon(stack, pass);
                    RENDER_ITEM.func_94149_a(0, 0, icon, 16, 16);
                }
                GL11.glPopAttrib();
                GL11.glTranslated((double)8.0, (double)8.0, (double)0.1);
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                scale = 16.0;
                break;
            }
        }
        Render.renderItem(stack, scale);
        GL11.glPopMatrix();
    }
}

