/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeThread;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.units.BlockState;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FinderState {
    private final Finder finder;
    private Entity carrier;
    private SharedData data;
    private CommonTime.Stamp lastUpdate;
    private BlockPos lastPosition;
    private Searcher searcher;
    private Map<Arrows, Arrows.Arrow> arrows = Collections.synchronizedMap(new EnumMap(Arrows.class));
    private List<Needle> needles = Collections.synchronizedList(new ArrayList());

    public FinderState(Finder finder, Entity carrier, SharedData data) {
        this.finder = finder;
        this.carrier = carrier;
        this.data = data;
    }

    @Nullable
    protected CommonTime.Stamp getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    protected BlockPos getLastPos() {
        return this.lastPosition;
    }

    public Entity getCarrier() {
        return this.carrier;
    }

    public int getNeedlesCount() {
        return this.needles.size();
    }

    public List<Needle> getNeedles() {
        return Collections.unmodifiableList(this.needles);
    }

    public Map<Arrows, Arrows.Arrow> getArrows() {
        return Collections.unmodifiableMap(this.arrows);
    }

    public boolean isVeinFound() {
        for (Arrows.Arrow arrow : this.arrows.values()) {
            if (arrow == null) continue;
            return true;
        }
        return false;
    }

    public boolean isActual() {
        return this.getLastUpdate() == null || CommonTime.Time.passedFrom((CommonTime.Stamp)this.getLastUpdate()).lessThan(Finder.STATE_TTL);
    }

    public boolean needsUpdate() {
        boolean isUpdateTime = this.getLastUpdate() == null || CommonTime.Time.passedFrom((CommonTime.Stamp)this.getLastUpdate()).moreThan(Finder.UPDATE_INTERVAL);
        boolean entityMoved = !ForgeEntity.getPosition((Entity)this.getCarrier()).equals((Object)this.getLastPos());
        return isUpdateTime || entityMoved;
    }

    public void update(Entity carrier, SharedData data) {
        this.setCarrier(carrier);
        this.setSharedData(data);
        if (this.searcher == null || !this.searcher.isAlive()) {
            this.searcher = new Searcher();
        }
        this.lastPosition = ForgeEntity.getPosition((Entity)this.getCarrier());
        this.lastUpdate = CommonTime.Stamp.now();
    }

    public Finder getFinder() {
        return this.finder;
    }

    public SharedData getSharedData() {
        return this.data;
    }

    protected void setSharedData(SharedData sharedData) {
        this.data = sharedData;
    }

    protected void setCarrier(Entity carrier) {
        this.carrier = carrier;
    }

    public static class UpdateMsg
    extends ForgeNetMsg<UpdateMsg> {
        public int entityId;

        public UpdateMsg() {
        }

        public UpdateMsg(EntityLivingBase entity) {
            this.entityId = entity.func_145782_y();
        }

        public IMessage onMessage(UpdateMsg message, MessageContext ctx) {
            EntityLivingBase living;
            ItemStack stack;
            Entity entity = this.findEntity(ctx, message.entityId);
            if (entity instanceof EntityLivingBase && Finder.stackHasFinder(stack = (living = (EntityLivingBase)entity).func_70694_bm())) {
                Finder finder = Finder.getFinderItem(stack);
                if (this.isServerSide(ctx)) {
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)Finder.SEARCH_BOUNDS.max.intValue());
                    finder.getMod().getRegistrator().networkChannel.sendToAllAround((IMessage)message, point);
                }
                if (this.isClientSide(ctx)) {
                    finder.updateState(living.field_70170_p, stack, (Entity)living, true);
                }
            }
            return null;
        }
    }

    protected class Searcher
    extends ForgeThread {
        public Searcher() {
            this.start();
        }

        public IntBounds getStartY() {
            int height = (int)FinderState.this.getCarrier().field_70131_O;
            if ((float)height == FinderState.this.getCarrier().field_70131_O) {
                --height;
            }
            int offset = FinderState.this.getCarrier() instanceof EntityPlayer ? -1 : 0;
            int minY = ForgeEntity.getPosition((Entity)FinderState.this.getCarrier()).getY() + offset;
            int maxY = minY + height;
            return new IntBounds(Integer.valueOf(minY), Integer.valueOf(maxY));
        }

        public int getStartX() {
            return ForgeEntity.getPosition((Entity)FinderState.this.getCarrier()).getX();
        }

        public int getStartZ() {
            return ForgeEntity.getPosition((Entity)FinderState.this.getCarrier()).getZ();
        }

        public World getWorld() {
            return FinderState.this.getCarrier().field_70170_p;
        }

        public void run() {
            this.searchVein();
            this.searchTargets();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchVein() {
            EnumMap<Arrows, Arrows.Arrow> updatedArrows = new EnumMap<Arrows, Arrows.Arrow>(Arrows.class);
            int foundBlocksCount = 0;
            BlockState lastState = BlockState.EMPTY;
            SharedData data = FinderState.this.getSharedData();
            IntBounds pingBounds = this.getStartY().extend(Integer.valueOf(data.pingDepth));
            IntBounds boundsY = ForgeBounds.HEIGHT.getIntBounds().enclose(pingBounds);
            ColorARGB color = null;
            block3: for (Arrows arrow : Arrows.values()) {
                int startY;
                int y = startY = (arrow == Arrows.OVERHEAD ? this.getStartY().max : this.getStartY().min).intValue();
                while (boundsY.encloses(Integer.valueOf(y))) {
                    BlockPos pos = new BlockPos(this.getStartX(), y, this.getStartZ());
                    BlockState state = ForgeWorld.getBlockState((World)this.getWorld(), (BlockPos)pos);
                    if (state.matches(lastState)) {
                        ++foundBlocksCount;
                    } else {
                        foundBlocksCount = 0;
                        for (Target target : FinderState.this.getFinder().getAllTargets()) {
                            if (!target.getBlockState().matches(state)) continue;
                            lastState = state;
                            foundBlocksCount = 1;
                            color = target.getColor();
                            break;
                        }
                    }
                    if (foundBlocksCount >= data.veinMinHeight) {
                        int distance = Math.abs(y - startY) - foundBlocksCount + 1;
                        TargetLocation location = TargetLocation.from(pos, distance);
                        updatedArrows.put(arrow, arrow.create(color, location));
                        continue block3;
                    }
                    y += arrow.step;
                }
            }
            Map map = FinderState.this.arrows;
            synchronized (map) {
                FinderState.this.arrows = updatedArrows;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchTargets() {
            ArrayList<Needle> updatedNeedles = new ArrayList<Needle>();
            SharedData data = FinderState.this.getSharedData();
            float dy = FinderState.this.getCarrier() instanceof EntityPlayer ? -1.8f : 0.0f;
            Vect3d finderPos = ForgeEntity.getCenterPosition((Entity)FinderState.this.getCarrier()).move(0.0, (double)dy, 0.0);
            IntBounds scanVertBounds = this.getStartY().extend(Integer.valueOf(2));
            IntBounds rangeY = ForgeBounds.HEIGHT.getIntBounds().enclose(scanVertBounds);
            IntBounds rangeX = new IntBounds(Integer.valueOf(this.getStartX())).extend(Integer.valueOf(data.scanRadius));
            IntBounds rangeZ = new IntBounds(Integer.valueOf(this.getStartZ())).extend(Integer.valueOf(data.scanRadius));
            for (List<Target> group : FinderState.this.getFinder().getTargetGroups().values()) {
                BlockPos nearestPos = null;
                ColorARGB color = null;
                double minDistance = Double.MAX_VALUE;
                for (int y = rangeY.min.intValue(); y <= rangeY.max; ++y) {
                    for (int z = rangeZ.min.intValue(); z <= rangeZ.max; ++z) {
                        for (int x = rangeX.min.intValue(); x <= rangeX.max; ++x) {
                            BlockPos pos = new BlockPos(x, y, z);
                            BlockState state = ForgeWorld.getBlockState((World)this.getWorld(), (BlockPos)pos);
                            for (Target target : group) {
                                double lastDistance;
                                if (!target.getBlockState().matches(state) || !((lastDistance = finderPos.distance(ForgeWorld.getBlockCenter((BlockPos)pos))) < minDistance)) continue;
                                nearestPos = pos;
                                color = target.getColor();
                                minDistance = lastDistance;
                            }
                        }
                    }
                }
                if (nearestPos == null) continue;
                TargetLocation location = TargetLocation.from(nearestPos, minDistance);
                updatedNeedles.add(new Needle(color, location));
            }
            Collections.sort(updatedNeedles, Needle.SORTING_COMPARATOR);
            List list = FinderState.this.needles;
            synchronized (list) {
                FinderState.this.needles = updatedNeedles;
            }
        }
    }

    public static class SharedData {
        public final int scanRadius;
        public final int pingDepth;
        public final int veinMinHeight;

        public SharedData(int scanRadius, int pingDepth, int veinMinHeight) {
            this.scanRadius = scanRadius;
            this.pingDepth = pingDepth;
            this.veinMinHeight = veinMinHeight;
        }
    }
}

