/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Comparator;
import org.lwjgl.opengl.GL11;

public class Needle
extends Indicator {
    private static final double WIDTH = 0.07;
    private static final double LENGTH = 0.25;
    public static final double OFFSET = 0.001;
    public static final Comparator<Needle> SORTING_COMPARATOR = (t1, t2) -> t1.equals(t2) ? 0 : -Double.compare(t1.getTargetLocation().getDistance(), t2.getTargetLocation().getDistance());

    public Needle(ColorARGB color, TargetLocation location) {
        super(color, location);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(CommonMath.Angle angle, double scale) {
        double degrees = angle.getDegrees();
        GL11.glRotated((double)degrees, (double)0.0, (double)0.0, (double)1.0);
        GL11.glColor4f((float)this.getColor().getRed().toFloat(), (float)this.getColor().getGreen().toFloat(), (float)this.getColor().getBlue().toFloat(), (float)this.getColor().getAlpha().toFloat());
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)(-0.035 * scale), (double)(-0.05 * scale), (double)0.0);
        GL11.glVertex3d((double)(0.035 * scale), (double)(-0.05 * scale), (double)0.0);
        GL11.glVertex3d((double)(0.035 * scale), (double)(0.25 * scale), (double)0.0);
        GL11.glVertex3d((double)(-0.035 * scale), (double)(0.25 * scale), (double)0.0);
        GL11.glEnd();
        GL11.glRotated((double)(-degrees), (double)0.0, (double)0.0, (double)1.0);
    }

    public CommonMath.Angle getAngle(Vect3d startPos, float rotationYaw) {
        Vect3d targetPos = ForgeWorld.getBlockCenter((BlockPos)this.getTargetLocation().getPos());
        Vect3d delta = startPos.subtract(targetPos);
        return CommonMath.Angle.fromDegrees((double)(rotationYaw - 90.0f - ForgeMath.arcTan((double)delta.z, (double)delta.x)));
    }
}

