/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class Render {
    public static void renderItem(ItemStack stack) {
        Render.renderItem(stack, 1.0);
    }

    public static void renderItem(ItemStack stack, double scale) {
        FinderState state = Finder.findStateFor(stack);
        if (state != null) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            Entity carrier = state.getCarrier();
            Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
            float rotationYaw = carrier.field_70177_z;
            if (carrier instanceof EntityLivingBase) {
                Minecraft mc = Minecraft.func_71410_x();
                if (carrier != mc.field_71439_g || mc.field_71474_y.field_74320_O > 0) {
                    rotationYaw = ((EntityLivingBase)carrier).field_70761_aq;
                }
            }
            double offset = 0.0;
            for (Arrows.Arrow arrow : state.getArrows().values()) {
                if (arrow == null) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)offset);
                arrow.draw(scale);
                GL11.glTranslated((double)0.0, (double)0.0, (double)Render.toBackSide(offset));
                arrow.draw(scale);
                GL11.glPopMatrix();
            }
            offset = 0.001;
            GL11.glTranslated((double)0.0, (double)0.0, (double)offset);
            for (Needle needle : state.getNeedles()) {
                CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)offset);
                needle.draw(angle, scale);
                GL11.glTranslated((double)0.0, (double)0.0, (double)Render.toBackSide(offset));
                needle.draw(angle, scale);
                offset += 0.001;
                GL11.glPopMatrix();
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    private static double toBackSide(double offset) {
        return -offset - (double)0.08f - offset;
    }
}

