/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.items;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.ForgeThread;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeKeys;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.mods.adfinders.finder.CustomRender;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.init.Finders;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class Finder
extends ForgeItem {
    public static final CommonTime.Time UPDATE_INTERVAL = CommonTime.Time.fromSeconds((double)1.0);
    public static final CommonTime.Time STATE_TTL = UPDATE_INTERVAL.mult(5.0);
    public static final IntBounds SEARCH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(64));
    public static final int VERT_RANGE = 2;
    public static final float THICKNESS = 0.08f;
    public static final String TARGETS_CONFIG_KEY = "targets";
    private final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final Map<Entity, FinderState> finderStates = new ConcurrentHashMap<Entity, FinderState>();
    private final Map<String, List<Target>> targetGroups = new ConcurrentHashMap<String, List<Target>>();
    private final List<Target> allTargets = new ArrayList<Target>();
    private final int scanRadius;
    private final int pingDepth;
    private final int veinMinHeight;
    private IIcon alarmIcon;
    private IIcon emptyIcon;
    private Cleaner cleaner;

    public Finder(ForgeMod mod, UnitConfig config, String name, Item baseMaterial, int scanRadius, int pingDepth) {
        super(mod, config, name, CreativeTabs.field_78040_i);
        this.scanRadius = ForgeConfig.getInt((ForgeConfig)config, (String)this.getConfigCategory(), (String)"scanRadius", (int)scanRadius, (IntBounds)SEARCH_BOUNDS, (String)"Defines how far from a player in horizontal plane the targets can be found.");
        this.pingDepth = ForgeConfig.getInt((ForgeConfig)config, (String)this.getConfigCategory(), (String)"pingDepth", (int)pingDepth, (IntBounds)SEARCH_BOUNDS, (String)"Defines how far from a player in vertical plane the ore vein can be found.");
        this.veinMinHeight = ForgeConfig.getInt((ForgeConfig)config, (String)this.getConfigCategory(), (String)"veinMinHeight", (int)2, (IntBounds)SEARCH_BOUNDS, (String)"Defines the minimal height of an ore vein to get alarm.");
        CraftingRecipe recipe = CraftingRecipe.CreateMain((ForgeConfig)config, (String)"121 232 424", (String)this.getStringId(), (int)1, (String[])new String[]{"repeater", Finder.getStringId((Item)baseMaterial), "compass", "comparator"});
        this.getMod().getRegistrator().addCrafting(recipe);
        this.func_77625_d(1);
    }

    public static boolean stackHasFinder(ItemStack stack) {
        return stack != null && stack.field_77994_a > 0 && stack.func_77973_b() instanceof Finder;
    }

    protected void addTargets(Target ... targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    protected void addTarget(Target target) {
        String name = target.getName();
        List<Target> group = this.targetGroups.get(name);
        if (group != null) {
            group.add(target);
        } else {
            group = new ArrayList<Target>();
            group.add(target);
            this.targetGroups.put(name, group);
        }
        this.allTargets.add(target);
    }

    protected void addTargets(Collection<Target> targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    public void onInit() {
        Definitions definitions = null;
        for (Finders finders : Finders.values()) {
            if (finders.instance != this) continue;
            definitions = finders.definitions;
        }
        if (definitions != null) {
            definitions.syncWithConfigs();
            for (String string : definitions.toArray()) {
                List<Target> targetList = Target.from(string);
                this.addTargets(targetList);
            }
        }
        super.onInit();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        this.alarmIcon = register.func_94245_a(this.getId().withNewName("alarm").toResLoc().toString());
        this.emptyIcon = register.func_94245_a(this.getId().withNewName("empty").toResLoc().toString());
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        FinderState state;
        if (pass == 0) {
            return this.field_77791_bV;
        }
        if (pass == 1 && (state = Finder.findStateFor(stack)) != null && state.isVeinFound()) {
            return this.alarmIcon;
        }
        return this.emptyIcon;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public boolean func_77629_n_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
        if (this.isEnabled()) {
            CustomRender customRender = new CustomRender();
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)customRender);
        }
        super.onInitClient();
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemStack) {
        return this.getChatFormatting() + super.func_77653_i(itemStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        EntityLivingBase living;
        boolean inHand = false;
        if (entity instanceof EntityLivingBase && stack.equals((living = (EntityLivingBase)entity).func_70694_bm())) {
            inHand = true;
        }
        this.updateState(world, stack, entity, inHand);
    }

    public void updateState(World world, ItemStack stack, Entity entity, boolean inHand) {
        NBTTagCompound tag = Finder.getFinderTag(stack);
        if (this.isServerSide(world) && tag == null) {
            FinderState.SharedData data = new FinderState.SharedData(this.getScanRadius(), this.getPingDepth(), this.getVeinMinHeight());
            Finder.createFinderTag(stack, data);
        }
        if (this.isClientSide(world) && tag != null) {
            FinderState state = Finder.findStateFor(stack);
            if (state == null) {
                state = this.createStateFor(stack, entity);
            }
            if (state != null && state.needsUpdate()) {
                state.update(entity, Finder.getSharedData(tag));
                if (inHand) {
                    FinderState.UpdateMsg message = new FinderState.UpdateMsg((EntityLivingBase)entity);
                    this.getMod().getRegistrator().networkChannel.sendToServer((IMessage)message);
                }
            }
            this.cleanOutdatedStates();
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.updateState(entityItem.field_70170_p, entityItem.func_92059_d(), (Entity)entityItem, false);
        return super.onEntityItemUpdate(entityItem);
    }

    @Nullable
    protected FinderState createStateFor(ItemStack stack, Entity carrier) {
        NBTTagCompound tag = Finder.getFinderTag(stack);
        if (tag != null) {
            FinderState.SharedData data = Finder.getSharedData(tag);
            this.carriers.put(stack, carrier);
            FinderState state = new FinderState(Finder.getFinderItem(stack), carrier, data);
            this.finderStates.put(carrier, state);
            return state;
        }
        return null;
    }

    @Nullable
    public static FinderState findStateFor(ItemStack stack) {
        if (Finder.stackHasFinder(stack)) {
            Finder finder = Finder.getFinderItem(stack);
            Entity entity = finder.carriers.get(stack);
            if (entity != null) {
                return finder.finderStates.get(entity);
            }
        }
        return null;
    }

    public static Finder getFinderItem(ItemStack stack) {
        return (Finder)stack.func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    public ChatFormatting getChatFormatting() {
        if (this == Finders.GEMS.instance) {
            return ChatFormatting.DARK_AQUA;
        }
        if (this == Finders.METALS.instance) {
            return ChatFormatting.GOLD;
        }
        if (this == Finders.MINERALS.instance) {
            return ChatFormatting.DARK_PURPLE;
        }
        return ChatFormatting.WHITE;
    }

    public int getScanRadius() {
        return this.scanRadius;
    }

    public int getPingDepth() {
        return this.pingDepth;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        FinderState state = Finder.findStateFor(stack);
        if (state != null) {
            GameSettings gs = ForgeKeys.getGameSettings();
            ChatFormatting textFormat = ChatFormatting.WHITE;
            if (ForgeKeys.isDown((KeyBinding)gs.field_151444_V)) {
                tooltip.add(textFormat + "Each finder has a " + ChatFormatting.AQUA + "vein detector");
                tooltip.add(textFormat + "which allows you to find " + ChatFormatting.AQUA + "ore veins");
                tooltip.add(textFormat + "deep under your feet or high above your head.");
                tooltip.add(ChatFormatting.RED + "Red lights" + textFormat + " signalize about " + ChatFormatting.AQUA + "found vein" + textFormat + ".");
                tooltip.add(ChatFormatting.GREEN + "Arrows" + textFormat + " show you the " + ChatFormatting.YELLOW + "direction" + textFormat + " of the " + ChatFormatting.AQUA + "vein" + textFormat + ".");
                tooltip.add(ChatFormatting.YELLOW + "Up" + textFormat + " means overhead.");
                tooltip.add(ChatFormatting.YELLOW + "Down" + textFormat + " means underfoot.");
            } else {
                FinderState.SharedData data = state.getSharedData();
                tooltip.add(ChatFormatting.WHITE + "Scan Radius: " + data.scanRadius);
                tooltip.add(ChatFormatting.GRAY + "Detection Depth: " + data.pingDepth);
                tooltip.add(ChatFormatting.GREEN + "Found Targets: " + state.getNeedlesCount());
                tooltip.add("hold " + ForgeKeys.getName((KeyBinding)gs.field_151444_V) + " for more info");
            }
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    @Nullable
    protected static NBTTagCompound getFinderTag(ItemStack stack) {
        String key = Tags.FINDER.name();
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(key) ? nbt.func_74775_l(key) : null;
    }

    protected static void createFinderTag(ItemStack stack, FinderState.SharedData data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(Tags.SCAN_RADIUS.name(), data.scanRadius);
        tag.func_74768_a(Tags.PING_DEPTH.name(), data.pingDepth);
        tag.func_74768_a(Tags.VEIN_MIN_HEIGHT.name(), data.veinMinHeight);
        Finder.ensureHasNBT((ItemStack)stack);
        stack.func_77978_p().func_74782_a(Tags.FINDER.name(), (NBTBase)tag);
    }

    protected static FinderState.SharedData getSharedData(NBTTagCompound finderTag) {
        int scanRadius = finderTag.func_74762_e(Tags.SCAN_RADIUS.name());
        int pingDepth = finderTag.func_74762_e(Tags.PING_DEPTH.name());
        int veinMinHeight = finderTag.func_74762_e(Tags.VEIN_MIN_HEIGHT.name());
        return new FinderState.SharedData(scanRadius, pingDepth, veinMinHeight);
    }

    public Map<String, List<Target>> getTargetGroups() {
        return Collections.unmodifiableMap(this.targetGroups);
    }

    public List<Target> getAllTargets() {
        return Collections.unmodifiableList(this.allTargets);
    }

    public Map<Entity, FinderState> getFinderStates() {
        return Collections.unmodifiableMap(this.finderStates);
    }

    public int getVeinMinHeight() {
        return this.veinMinHeight;
    }

    private void cleanOutdatedStates() {
        if (this.cleaner == null || this.cleaner.isTimeToRun()) {
            this.cleaner = new Cleaner();
        }
    }

    public class Cleaner
    extends ForgeThread {
        private final CommonTime.Time RUN_INTERVAL = UPDATE_INTERVAL.mult(5.0);
        private final CommonTime.Stamp wasRunAt = CommonTime.Stamp.now();

        public Cleaner() {
            this.start();
        }

        public boolean isTimeToRun() {
            CommonTime.Time passed = CommonTime.Time.passedFrom((CommonTime.Stamp)this.wasRunAt);
            return !this.isAlive() && passed.moreThan(this.RUN_INTERVAL);
        }

        public void run() {
            Iterator<Object> iterator = Finder.this.finderStates.values().iterator();
            while (iterator.hasNext()) {
                FinderState state = (FinderState)iterator.next();
                if (state.isActual()) continue;
                iterator.remove();
            }
            iterator = Finder.this.carriers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                Entity entity = (Entity)entry.getValue();
                if (stack.field_77994_a > 0 && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
                iterator.remove();
            }
            iterator = Finder.this.carriers.values().iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (Finder.this.finderStates.get(entity) != null) continue;
                iterator.remove();
            }
        }
    }

    static enum Tags {
        FINDER,
        SCAN_RADIUS,
        PING_DEPTH,
        PING_DIRECTION,
        VEIN_MIN_HEIGHT;

    }
}

