/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.Vect3d;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class ForgeNBT {
    public static final String KEY_UUID_MOST = "M";
    public static final String KEY_UUID_LEAST = "L";
    public static final String KEY_VEC3_X = "X";
    public static final String KEY_VEC3_Y = "Y";
    public static final String KEY_VEC3_Z = "Z";

    @Nonnull
    public static NBTTagCompound getTag(NBTTagCompound compound, String key) {
        return compound != null && key != null ? compound.func_74775_l(key) : new NBTTagCompound();
    }

    public static boolean hasKey(NBTTagCompound compound, String key) {
        return compound != null && compound.func_74764_b(key);
    }

    public static void writeUUID(NBTTagCompound compound, String key, UUID uuid) {
        if (compound != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(KEY_UUID_MOST, uuid.getMostSignificantBits());
            tag.func_74772_a(KEY_UUID_LEAST, uuid.getLeastSignificantBits());
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static UUID readUUID(NBTTagCompound compound, String key) {
        NBTTagCompound tag = ForgeNBT.getTag(compound, key);
        return new UUID(tag.func_74763_f(KEY_UUID_MOST), tag.func_74763_f(KEY_UUID_LEAST));
    }

    public static void writeVec3d(NBTTagCompound compound, String key, Vect3d vec) {
        if (compound != null && vec != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a(KEY_VEC3_X, vec.x);
            tag.func_74780_a(KEY_VEC3_Y, vec.y);
            tag.func_74780_a(KEY_VEC3_Z, vec.z);
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static Vect3d readVec3d(NBTTagCompound compound, String key) {
        NBTTagCompound tag = ForgeNBT.getTag(compound, key);
        return Vect3d.from(tag.func_74769_h(KEY_VEC3_X), tag.func_74769_h(KEY_VEC3_Y), tag.func_74769_h(KEY_VEC3_Z));
    }

    public static void writeBlockPos(NBTTagCompound compound, String key, BlockPos pos) {
        if (compound != null && pos != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a(KEY_VEC3_X, (double)pos.getX());
            tag.func_74780_a(KEY_VEC3_Y, (double)pos.getY());
            tag.func_74780_a(KEY_VEC3_Z, (double)pos.getZ());
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static NBTTagCompound readFromByteBuf(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static void writeToByteBuf(NBTTagCompound compound, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
    }

    public static BlockPos readBlockPos(NBTTagCompound compound, String key) {
        NBTTagCompound tag = ForgeNBT.getTag(compound, key);
        return new BlockPos(tag.func_74762_e(KEY_VEC3_X), tag.func_74762_e(KEY_VEC3_Y), tag.func_74762_e(KEY_VEC3_Z));
    }

    @Nullable
    public static <T extends Enum<T>> T readEnumValue(NBTTagCompound compound, Class<T> enumClass) {
        if (compound != null && enumClass != null) {
            String name = compound.func_74779_i(enumClass.getSimpleName());
            return Enum.valueOf(enumClass, name);
        }
        return null;
    }

    public static <T extends Enum<T>> void writeEnumValue(NBTTagCompound compound, T enumValue) {
        if (compound != null && enumValue != null) {
            compound.func_74778_a(enumValue.getClass().getSimpleName(), enumValue.name());
        }
    }

    public static Types getType(NBTTagCompound compound, String key) {
        if (compound != null) {
            byte id = compound.func_150299_b(key);
            for (Types type : Types.values()) {
                if (type.id != id) continue;
                return type;
            }
        }
        return Types.NULL;
    }

    public static enum Types {
        NULL(0),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        FLOAT(5),
        DOUBLE(6),
        BYTE$$(7),
        STRING(8),
        LIST(9),
        COMPOUND(10),
        INT$$(11),
        ORDINAL(99);

        public final int id;

        private Types(int id) {
            this.id = id;
        }

        public boolean isOrdinal() {
            return this.id == 99 || this.id >= 1 && this.id <= 6;
        }

        public String toString() {
            String string = this.name().toLowerCase(Locale.ROOT);
            return this.isOrdinal() ? string : CommonString.capitalizeFirstChar(string).replace("$$", "[]");
        }
    }
}

