/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.math.MathHelper;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.Objects;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;

public class BlockPos {
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;
    private static final int SINGLE_OFFSET = 1;
    public static final BlockPos ZERO;
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static BlockPos from(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static BlockPos from(MovingObjectPosition rayTraceResult) {
        return BlockPos.from(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d);
    }

    public static BlockPos from(ChunkCoordinates coords) {
        return new BlockPos(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
    }

    public static BlockPos fromLong(long serialized) {
        int i = (int)(serialized << 64 - X_SHIFT - NUM_X_BITS >> 64 - NUM_X_BITS);
        int j = (int)(serialized << 64 - Y_SHIFT - NUM_Y_BITS >> 64 - NUM_Y_BITS);
        int k = (int)(serialized << 64 - NUM_Z_BITS >> 64 - NUM_Z_BITS);
        return new BlockPos(i, j, k);
    }

    public static BlockPos from(Vect3d vec) {
        return BlockPos.from(MathHelper.floor(vec.x), MathHelper.floor(vec.y), MathHelper.floor(vec.z));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos up(int offset) {
        return BlockPos.from(this.getX(), this.getY() + offset, this.getZ());
    }

    public BlockPos down(int offset) {
        return BlockPos.from(this.getX(), this.getY() - offset, this.getZ());
    }

    public BlockPos west(int offset) {
        return BlockPos.from(this.getX() - offset, this.getY(), this.getZ());
    }

    public BlockPos east(int offset) {
        return BlockPos.from(this.getX() + offset, this.getY(), this.getZ());
    }

    public BlockPos north(int offset) {
        return BlockPos.from(this.getX(), this.getY(), this.getZ() - offset);
    }

    public BlockPos south(int offset) {
        return BlockPos.from(this.getX(), this.getY(), this.getZ() + offset);
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockPos) {
            BlockPos pos = (BlockPos)obj;
            return pos.getX() == this.getX() && pos.getY() == this.getY() && pos.getZ() == this.getZ();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getX(), this.getY(), this.getZ());
    }

    public long toLong() {
        return ((long)this.getX() & X_MASK) << X_SHIFT | ((long)this.getY() & Y_MASK) << Y_SHIFT | ((long)this.getZ() & Z_MASK) << 0;
    }

    public String toString() {
        return BlockPos.class.getSimpleName() + Args.group(Args.get("x", this.getX()), Args.get("y", this.getY()), Args.get("z", this.getZ()));
    }

    public double distanceSq(BlockPos pos) {
        double dx = this.getX() - pos.getX();
        double dy = this.getY() - pos.getY();
        double dz = this.getZ() - pos.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public BlockPos offset(EnumFacing facing, int amount) {
        switch (facing) {
            case DOWN: {
                return this.down(amount);
            }
            case UP: {
                return this.up(amount);
            }
            case EAST: {
                return this.east(amount);
            }
            case WEST: {
                return this.west(amount);
            }
            case NORTH: {
                return this.north(amount);
            }
            case SOUTH: {
                return this.south(amount);
            }
        }
        return this;
    }

    public BlockPos offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathHelper.log2(MathHelper.smallestEncompassingPowerOfTwo(30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_SHIFT = 0 + NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
        ZERO = BlockPos.from(0, 0, 0);
    }
}

