/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import net.minecraft.entity.Entity;

public class MotionMsg
extends ForgeNetMsg<MotionMsg> {
    public int id = -1;
    public int type = Type.add.ordinal();
    public Vect3d motion = Vect3d.ZERO;

    public MotionMsg() {
    }

    public MotionMsg(Entity entity, Type type, Vect3d motion) {
        if (entity != null) {
            this.id = ForgeEntity.getId(entity);
        }
        if (type != null) {
            this.type = type.ordinal();
        }
        if (motion != null) {
            this.motion = motion;
        }
    }

    public static MotionMsg setMotion(Entity entity, Vect3d motion) {
        return new MotionMsg(entity, Type.set, motion);
    }

    public static MotionMsg addMotion(Entity entity, Vect3d motion) {
        return new MotionMsg(entity, Type.add, motion);
    }

    public IMessage onMessage(MotionMsg message, MessageContext ctx) {
        Entity entity;
        if (message != null && (entity = this.findEntity(ctx, message.id)) != null) {
            switch (Type.values()[message.type]) {
                case add: {
                    ForgeEntity.addMotion(entity, message.motion);
                    break;
                }
                case set: {
                    ForgeEntity.setMotion(entity, message.motion);
                    break;
                }
            }
        }
        return null;
    }

    public static enum Type {
        add,
        set;

    }
}

