/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.mods.adfinders.finder.BuiltInModel;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Renderer;
import com.endertech.minecraft.mods.adfinders.init.Finders;
import com.endertech.minecraft.mods.adfinders.init.Targets;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="adfinders", name="Advanced Finders", version="1.12.2-2.3.14.0", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forgeendertech@[1.12.2-4.5.2.0,);after:*")
public class Main
extends ForgeMod {
    public static final String ID = "adfinders";
    public static final String NAME = "Advanced Finders";
    @Mod.Instance(value="adfinders")
    public static Main instance;

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new ModConfig(ID, event));
        this.getRegistrator().registerInEventBus((Object)this);
        this.getRegistrator().registerNetMessageHandledOnBothSides(FinderState.UpdateMsg.class, FinderState.UpdateMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnClient(Finder.SyncClientMsg.class, Finder.SyncClientMsg.handler.class);
        Finders.values();
        super.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        Targets.init();
        super.init(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        for (Finders finder : Finders.values()) {
            finder.instance.setTileEntityItemStackRenderer(new Renderer());
        }
        super.initClient(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void replaceModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (Finders finder : Finders.values()) {
            for (String variant : new String[]{"normal", "alarmed"}) {
                ModelResourceLocation loc = new ModelResourceLocation(finder.instance.getRegistryName(), variant);
                IBakedModel original = (IBakedModel)registry.func_82594_a((Object)loc);
                if (original == null) continue;
                registry.func_82595_a((Object)loc, (Object)new BuiltInModel(original));
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.postInit(event);
    }
}

