/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.BuiltInModel;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Renderer
extends TileEntityItemStackRenderer {
    public void func_179022_a(ItemStack stack) {
        IBakedModel model = this.getItemRenderer().func_184393_a(stack, null, null);
        if (model instanceof BuiltInModel) {
            model = ((BuiltInModel)model).getOriginalModel();
        }
        if (!model.func_188618_c()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            this.getItemRenderer().func_180454_a(stack, model);
            GlStateManager.func_179121_F();
        }
        this.renderIndicators(stack);
    }

    RenderItem getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    void renderIndicators(ItemStack stack) {
        double scale = 1.0;
        FinderState state = Finder.findStateFor(stack);
        if (state == null) {
            return;
        }
        ForgeRendering.MeterIndicators.beforeRender((float)0.08f);
        Entity carrier = state.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.field_70177_z;
        if (carrier instanceof EntityLivingBase) {
            Minecraft mc = Minecraft.func_71410_x();
            if (carrier != mc.field_71439_g || mc.field_71474_y.field_74320_O > 0) {
                rotationYaw = ((EntityLivingBase)carrier).field_70761_aq;
            }
        }
        double offset = 0.0;
        for (Arrows.Arrow arrow : state.getArrows().values()) {
            if (arrow == null) continue;
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)offset);
            arrow.draw(1.0);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-offset));
        }
        offset = 0.001;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)offset);
        for (Needle needle : state.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)offset);
            needle.draw(angle, 1.0);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-offset));
            offset += 0.001;
        }
        ForgeRendering.MeterIndicators.afterRender();
    }
}

